<%--

    Licensed to The OpenNMS Group, Inc (TOG) under one or more
    contributor license agreements.  See the LICENSE.md file
    distributed with this work for additional information
    regarding copyright ownership.

    TOG licenses this file to You under the GNU Affero General
    Public License Version 3 (the "License") or (at your option)
    any later version.  You may not use this file except in
    compliance with the License.  You may obtain a copy of the
    License at:

         https://www.gnu.org/licenses/agpl-3.0.txt

    Unless required by applicable law or agreed to in writing,
    software distributed under the License is distributed on an
    "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
    either express or implied.  See the License for the specific
    language governing permissions and limitations under the
    License.

--%>
<%@page language="java"
	contentType="text/html"
	session="true"
	import="java.util.*,
		org.opennms.web.admin.notification.noticeWizard.*,
		org.opennms.netmgt.config.notifications.*,
        org.opennms.netmgt.config.destinationPaths.*,
		org.opennms.netmgt.config.*
	"
%>
<%@ page import="org.opennms.core.utils.WebSecurityUtils" %>

<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>


<%!
    public void init() throws ServletException {
        try {
            DestinationPathFactory.init();
        }
        catch( Exception e ) {
            throw new ServletException( "Cannot load configuration file", e );
        }
    }
%>

<%
    HttpSession user = request.getSession(true);
    Notification newNotice = (Notification)user.getAttribute("newNotice");
    Varbind varbind=newNotice.getVarbind();
    String varbindName="";
    String varbindValue="";
    if(varbind!=null) {
        
        if(varbind.getVbname()!=null) {
            varbindName=varbind.getVbname();
		}
        if(varbind.getVbvalue()!=null) {
         	varbindValue=varbind.getVbvalue();
        }
    }
    final int paramSize = newNotice.getParameters().size();
    String parameterName[] = new String[paramSize];
    String parameterValue[] = new String[paramSize];
    int p=0;
    for(final Parameter parameter : newNotice.getParameters()) {
        parameterName[p] = parameter.getName();
        parameterValue[p] = parameter.getValue();
        p++;
    }
%>

<%@ page import="org.opennms.web.utils.Bootstrap" %>
<% Bootstrap.with(pageContext)
          .headTitle("Choose Path")
          .headTitle("Admin")
          .breadcrumb("Admin", "admin/index.jsp")
          .breadcrumb("Configure Notifications", "admin/notification/index.jsp")
          .breadcrumb("Choose Path")
          .build(request);
%>
<jsp:directive.include file="/includes/bootstrap.jsp" />

<script type="text/javascript" >
  
    function trimString(str) 
    {
        while (str.charAt(0)==" ")
        {
          str = str.substring(1);
        }
        while (str.charAt(str.length - 1)==" ")
        {
          str = str.substring(0, str.length - 1);
        }
        return str;
    }
    
    function finish()
    {
        trimmedName = trimString(document.info.name.value);
        trimmedText = trimString(document.info.textMsg.value);
        if (trimmedName=="")
        {
            alert("Please give this notification a name.");
        }
        else if (trimmedText=="")
        {
            alert("Please enter a text message for this notification.");
        }
        else if (document.info.path.selectedIndex==-1)
        {
            alert("Please select a destination path for this notification.");
        }
        else
        {
            document.info.submit();
        }
    }
  
</script>

<script type="text/javascript">
    // add row
    $(document).ready(function() {
        $("#addRow").click(function () {
            var html = '';
            html+='<div class="row" id="inputFormRow">';
            html+='  <div class="col-md-5">';
            html+='    <label>Name:</label> <input type="text" class="form-control" size="30" name="parameterName" value=""/>';
            html+='  </div>';
            html+='  <div class="col-md-5">';
            html+='    <label>Value:</label> <input class="form-control" type="text" size="30" name="parameterValue" value=""/>';
            html+='  </div>';
            html+='  <div class="col-md-2">';
            html+='    <label>&nbsp;&nbsp;&nbsp;</label><button class="form-control" id="removeRow" type="button" class="btn btn-danger">Remove</button>';
            html+='  </div>';
            html+='</div>';
            $('#newRow').append(html);
        });
    });

    // remove row
    $(document).on('click', '#removeRow', function () {
        $(this).closest('#inputFormRow').remove();
    });
</script>

<h2><%=(newNotice.getName()!=null ? "Editing notice: " + WebSecurityUtils.sanitizeString(newNotice.getName()) + "<br/>" : "")%></h2>

<form method="post" name="info"
      action="admin/notification/noticeWizard/notificationWizard">
      <input type="hidden" name="userAction" value=""/>
      <input type="hidden" name="sourcePage" value="<%=NotificationWizardServlet.SOURCE_PAGE_PATH%>"/>

<div class="row">
  <div class="col-md-7">
    <div class="card">
      <div class="card-header">
        <span>Choose the destination path and enter the information to send via the notification</span>
      </div>
      <table class="table table-sm">
        <tr>
          <td width="10%" valign="top" align="left">
            <label>Name:</label>
          </td>
          <td valign="top" align="left">
            <input type="text" class="form-control" name="name" value='<%=(newNotice.getName()!=null ? WebSecurityUtils.sanitizeString(newNotice.getName()) : "")%>'/>
          </td>
        </tr>
        <tr>
          <td width="10%" valign="top" align="left">
            <label>Description:</label>
          </td>
          <td valign="top" align="left">
            <input type="text" class="form-control" name="description" value='<%=WebSecurityUtils.sanitizeString(newNotice.getDescription().orElse(""))%>'/>
          </td>
        </tr>
        <tr>
          <td width="10%" valign="top" align="left">
            <label>Var-Bind:</label>
          </td>
          <td valign="top" align="left">
            <div class="row">
              <div class="col-md-6">
                <label>Name:</label> <input type="text" class="form-control" size="30" name="varbindName" value='<%=WebSecurityUtils.sanitizeString(varbindName)%>'/>
              </div>
              <div class="col-md-6">
                <label>Value:</label> <input class="form-control" type="text" size="30" name="varbindValue" value='<%=WebSecurityUtils.sanitizeString(varbindValue)%>'/>
              </div>
            </div>
          </td>
        </tr>

          <tr>
              <td width="10%" valign="top" align="left">
                  <label>Parameter:</label>
              </td>
              <td valign="top" align="left">
                  <div id="newRow">
                      <%
                          for(int i=0;i<parameterName.length;i++) {
                            %>
                              <div class="row" id="inputFormRow">
                                <div class="col-md-5">
                                  <label>Name:</label> <input type="text" class="form-control" size="30" name="parameterName" value='<%=WebSecurityUtils.sanitizeString(parameterName[i])%>'/>
                                </div>
                                <div class="col-md-5">
                                  <label>Value:</label> <input class="form-control" type="text" size="30" name="parameterValue" value='<%=WebSecurityUtils.sanitizeString(parameterValue[i])%>'/>
                                </div>
                                <div class="col-md-2">
                                  <label>&nbsp;&nbsp;&nbsp;</label><button class="form-control" id="removeRow" type="button" class="btn btn-danger">Remove</button>
                                </div>
                              </div>
                            <%
                          }
                      %>
                  </div>
                  <br/>
                  <button id="addRow" type="button" class="btn btn-secondary">Add Parameter</button>
              </td>
          </tr>

          <tr>
          <td width="10%" valign="top" align="left">
            <label>Choose A Path:</label>
          </td>
          <td valign="top" align="left">
            <%=buildPathSelect(newNotice.getDestinationPath())%>
          </td>
        </tr>
        <tr>
          <td width="10%" valign="top" align="left">
            <label>Text Message:</label>
          </td>
          <td valign="top" align="left">
            <textarea rows="3" class="form-control" name="textMsg"><%=(newNotice.getTextMessage()!=null ? WebSecurityUtils.sanitizeString(newNotice.getTextMessage()) : "")%></textarea>
          </td>
        </tr>
        <tr>
          <td width="10%" valign="top" align="left">
            <label>Short Message:</label>
          </td>
          <td valign="top" align="left">
            <textarea rows="1" class="form-control" name="numMsg"><%=WebSecurityUtils.sanitizeString(newNotice.getNumericMessage().orElse(""))%></textarea>
          </td>
        </tr>
        <tr>
          <td width="10%" valign="top" align="left">
            <label>Email Subject:</label>
          </td>
          <td valign="top" align="left">
            <input type="text" class="form-control" name="subject" value='<%=WebSecurityUtils.sanitizeString(newNotice.getSubject().orElse(""))%>'/>
          </td>
        </tr>
        <tr>
          <td width="10%" valign="top" align="left">
            <label>Special Values:</label>
          </td>
          <td valign="top" align="left">
            <table class="table table-sm">
              <tr>
                <td colspan="3">Can be used in both the text message and email subject:</td>
              </tr>
              <tr>
                <td>%noticeid% = Notification ID number</td>
                <td>%time% = Time sent</td>
                <td>%severity% = Event severity</td>
              </tr>
              <tr>
                <td>%nodelabel% = May be IP address or empty</td>
                <td>%nodeid% = Database ID of node or empty</td>
                <td>%foreignid% = Foreign Source ID of node or empty</td>
              </tr>
              <tr>
                <td>%eventid% = Event ID, may be empty</td>
                <td>%interface% = IP address, may be empty</td>
                <td>%service% = Service name, may be empty</td>
              </tr>
              <tr>
                <td>%ifalias% = SNMP ifAlias of affected interface</td>
                <td>%parm[a_parm_name]% = Value of a named event parameter</td>
                <td>%parm[#N]% = Value of the event parameter at index N</td>
              </tr>
              <tr>
                <td>%interfaceresolve% = Reverse DNS name of interface IP address</td>
                <td>%operinstruct% = Operator instructions from event definition</td>
                <td>\${context:key|…} = node / interface / service meta-data</td>
              </tr>
            </table>
          </td>
        </tr>
      </table>
        <div class="card-footer">
              <a class="btn btn-secondary" href="javascript:finish()">Finish</a>
        </div>
    </div> <!-- panel -->
  </div> <!-- column -->
</div> <!-- row -->

</form>

<jsp:include page="/includes/bootstrap-footer.jsp" flush="false" />

<%!
    public String buildPathSelect(String currentPath)
      throws ServletException
    {
         StringBuffer buffer = new StringBuffer("<select class=\"form-control custom-select\" NAME=\"path\">");
         
         Map<String, Path> pathsMap = null;
         
         try {
             pathsMap = new TreeMap<String, Path>(DestinationPathFactory.getInstance().getPaths());
             for (String key : pathsMap.keySet()) {
                 if (key.equals(currentPath))
                 {
                    buffer.append("<option SELECTED VALUE=" + key + ">" + key + "</option>");
                 }
                 else
                 {
                    buffer.append("<option VALUE=" + key + ">" + key + "</option>");
                 }
             }
         } catch (Throwable e)
         {
            throw new ServletException("couldn't get destination path list.", e);
         }
         buffer.append("</select>");
         
         return buffer.toString();
    }
%>
