/*
 * Licensed to The OpenNMS Group, Inc (TOG) under one or more
 * contributor license agreements.  See the LICENSE.md file
 * distributed with this work for additional information
 * regarding copyright ownership.
 *
 * TOG licenses this file to You under the GNU Affero General
 * Public License Version 3 (the "License") or (at your option)
 * any later version.  You may not use this file except in
 * compliance with the License.  You may obtain a copy of the
 * License at:
 *
 *      https://www.gnu.org/licenses/agpl-3.0.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.  See the License for the specific
 * language governing permissions and limitations under the
 * License.
 */
package org.opennms.netmgt.dao.mock;

import java.util.UUID;

import org.opennms.netmgt.dao.api.DistPollerDao;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.model.OnmsDistPoller;

public class MockDistPollerDao extends AbstractMockDao<OnmsDistPoller,String> implements DistPollerDao {

    public final static String DEFAULT_DIST_POLLER_ID = "00000000-0000-0000-0000-000000000000";
    @Override
    protected void generateId(final OnmsDistPoller dp) {
        dp.setId(UUID.randomUUID().toString());
    }

    @Override
    protected String getId(final OnmsDistPoller dp) {
        return dp == null? null : dp.getId();
    }

    @Override
    public OnmsDistPoller whoami() {
        final OnmsDistPoller defaultDistPoller = get(DEFAULT_DIST_POLLER_ID);
        if (defaultDistPoller != null) {
            return defaultDistPoller;
        }
        final OnmsDistPoller whoami = new OnmsDistPoller();
        whoami.setId(DEFAULT_DIST_POLLER_ID);
        whoami.setLabel("localhost");
        whoami.setLocation(MonitoringLocationDao.DEFAULT_MONITORING_LOCATION_ID);
        return whoami;
    }
}
