/*
 * Licensed to The OpenNMS Group, Inc (TOG) under one or more
 * contributor license agreements.  See the LICENSE.md file
 * distributed with this work for additional information
 * regarding copyright ownership.
 *
 * TOG licenses this file to You under the GNU Affero General
 * Public License Version 3 (the "License") or (at your option)
 * any later version.  You may not use this file except in
 * compliance with the License.  You may obtain a copy of the
 * License at:
 *
 *      https://www.gnu.org/licenses/agpl-3.0.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.  See the License for the specific
 * language governing permissions and limitations under the
 * License.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.validation;

import org.opennms.features.vaadin.jmxconfiggenerator.Config;

import com.vaadin.v7.data.validator.StringLengthValidator;

public class MaximumLengthValidator extends StringLengthValidator {

    protected static final String ERROR_MESSAGE = "You must specify a valid attribute name. Only characters a-z, A-Z and 0-9 are allowed.";

    public MaximumLengthValidator() {
        super(ERROR_MESSAGE, 0, Config.ATTRIBUTES_ALIAS_MAX_LENGTH, false);
    }
}
