/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.builder.smart;

import java.util.List;
import org.apache.maven.execution.ProjectDependencyGraph;
import org.apache.maven.project.MavenProject;

interface DependencyGraph<K> {
    public List<K> getDownstreamProjects(K var1);

    public List<K> getSortedProjects();

    public List<K> getUpstreamProjects(K var1);

    public static DependencyGraph<MavenProject> fromMaven(final ProjectDependencyGraph graph) {
        return new DependencyGraph<MavenProject>(){

            @Override
            public List<MavenProject> getDownstreamProjects(MavenProject project) {
                return graph.getDownstreamProjects(project, false);
            }

            @Override
            public List<MavenProject> getSortedProjects() {
                return graph.getSortedProjects();
            }

            @Override
            public List<MavenProject> getUpstreamProjects(MavenProject project) {
                return graph.getUpstreamProjects(project, false);
            }
        };
    }
}

