/*
 * Licensed to The OpenNMS Group, Inc (TOG) under one or more
 * contributor license agreements.  See the LICENSE.md file
 * distributed with this work for additional information
 * regarding copyright ownership.
 *
 * TOG licenses this file to You under the GNU Affero General
 * Public License Version 3 (the "License") or (at your option)
 * any later version.  You may not use this file except in
 * compliance with the License.  You may obtain a copy of the
 * License at:
 *
 *      https://www.gnu.org/licenses/agpl-3.0.txt
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.  See the License for the specific
 * language governing permissions and limitations under the
 * License.
 */
package org.opennms.netmgt.topologies.service.api;

import java.util.Objects;

public class OnmsTopologyProtocol {

    private static final OnmsTopologyProtocol ALL_PROTOCOLS = create("ALL");

    public static OnmsTopologyProtocol create(String id) {
        Objects.requireNonNull(id, "id is null, cannot create protocol");
        return new OnmsTopologyProtocol(id.toUpperCase());
    }
    
    public static OnmsTopologyProtocol allProtocols() {
        return ALL_PROTOCOLS;
    }
    
    final private String m_id;

    private OnmsTopologyProtocol(String id) {
        m_id=id;
    }

    public String getId() {
        return m_id;
    }

    public String toString() {
        return m_id;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((m_id == null) ? 0 : m_id.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        OnmsTopologyProtocol other = (OnmsTopologyProtocol) obj;
        if (m_id == null) {
            if (other.m_id != null)
                return false;
        } else if (!m_id.equals(other.m_id))
            return false;
        return true;
    }

}
