/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "bez" locale.
 */
public class LocalizedNamesImpl_bez extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AQ",
        "AX",
        "BL",
        "BQ",
        "BV",
        "CC",
        "CP",
        "CW",
        "CX",
        "DG",
        "EA",
        "EH",
        "EU",
        "EZ",
        "FO",
        "GG",
        "GS",
        "HK",
        "HM",
        "ZA",
        "AF",
        "IS",
        "AR",
        "AL",
        "DZ",
        "AW",
        "AM",
        "AD",
        "AO",
        "AI",
        "AG",
        "AT",
        "AU",
        "IE",
        "AZ",
        "BB",
        "BH",
        "BS",
        "BD",
        "BY",
        "BZ",
        "BM",
        "BJ",
        "BR",
        "BO",
        "BA",
        "BW",
        "BN",
        "BF",
        "MG",
        "BG",
        "BI",
        "BT",
        "TD",
        "CL",
        "CN",
        "DK",
        "DM",
        "EC",
        "SV",
        "ER",
        "EE",
        "AE",
        "FJ",
        "PH",
        "GA",
        "GM",
        "GH",
        "GW",
        "GQ",
        "GD",
        "GY",
        "GP",
        "GU",
        "GT",
        "GF",
        "HT",
        "ES",
        "HN",
        "HU",
        "IQ",
        "IN",
        "ID",
        "IL",
        "IT",
        "JM",
        "JP",
        "GI",
        "DJ",
        "GN",
        "GL",
        "GE",
        "KH",
        "CM",
        "CA",
        "QA",
        "KZ",
        "KE",
        "CV",
        "KI",
        "KG",
        "CI",
        "KP",
        "KR",
        "CO",
        "KM",
        "CG",
        "HR",
        "CR",
        "CU",
        "CY",
        "KW",
        "LA",
        "LU",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "RE",
        "RO",
        "RW",
        "MW",
        "US",
        "MY",
        "ML",
        "MT",
        "MQ",
        "MK",
        "YT",
        "MX",
        "FM",
        "EG",
        "MV",
        "MD",
        "MU",
        "MR",
        "MA",
        "MC",
        "MN",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NO",
        "NC",
        "NZ",
        "OM",
        "PK",
        "PY",
        "PW",
        "PA",
        "PG",
        "PE",
        "PN",
        "PL",
        "PF",
        "PR",
        "SM",
        "WS",
        "AS",
        "SH",
        "KN",
        "LC",
        "PM",
        "VC",
        "ST",
        "SA",
        "SN",
        "SC",
        "SL",
        "SY",
        "SG",
        "LK",
        "SK",
        "SI",
        "SO",
        "SD",
        "SR",
        "TH",
        "TW",
        "TJ",
        "TZ",
        "TL",
        "TG",
        "TK",
        "TO",
        "TT",
        "TN",
        "TV",
        "IR",
        "BE",
        "FR",
        "FI",
        "UG",
        "GR",
        "ET",
        "NL",
        "GB",
        "DE",
        "UA",
        "PT",
        "UY",
        "RU",
        "SZ",
        "SE",
        "CH",
        "TR",
        "TM",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "WF",
        "YE",
        "JO",
        "ZM",
        "ZW",
        "IC",
        "FK",
        "KY",
        "CK",
        "MP",
        "MH",
        "SB",
        "TC",
        "VG",
        "VI",
        "NF",
        "CF",
        "CZ",
        "CD",
        "DO",
        "IM",
        "JE",
        "ME",
        "MF",
        "MO",
        "QO",
        "RS",
        "SJ",
        "SS",
        "SX",
        "TA",
        "TF",
        "IO",
        "PS",
        "UM",
        "UN",
        "XA",
        "XB",
        "XK",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Huandola");
    namesMap.put("AE", "Hufalme dza Hihalabu");
    namesMap.put("AF", "Huafuganistani");
    namesMap.put("AG", "Huantigua na Hubarubuda");
    namesMap.put("AI", "Huanguila");
    namesMap.put("AL", "Hualbania");
    namesMap.put("AM", "Huamenia");
    namesMap.put("AO", "Huangola");
    namesMap.put("AR", "Huajendina");
    namesMap.put("AS", "Husamoa ya Humalekani");
    namesMap.put("AT", "Huastlia");
    namesMap.put("AU", "Huaustlalia");
    namesMap.put("AW", "Hualuba");
    namesMap.put("AZ", "Huazabajani");
    namesMap.put("BA", "Hubosinia na Huhezegovina");
    namesMap.put("BB", "Hubabadosi");
    namesMap.put("BD", "Hubangaladeshi");
    namesMap.put("BE", "Huubelgiji");
    namesMap.put("BF", "Hubukinafaso");
    namesMap.put("BG", "Hubulgaria");
    namesMap.put("BH", "Hubahaleni");
    namesMap.put("BI", "Huburundi");
    namesMap.put("BJ", "Hubenini");
    namesMap.put("BM", "Hubelmuda");
    namesMap.put("BN", "Hubrunei");
    namesMap.put("BO", "Hubolivia");
    namesMap.put("BR", "Hublazili");
    namesMap.put("BS", "Hubahama");
    namesMap.put("BT", "Hubutani");
    namesMap.put("BW", "Hubotiswana");
    namesMap.put("BY", "Hubelalusi");
    namesMap.put("BZ", "Hubelize");
    namesMap.put("CA", "Hukanada");
    namesMap.put("CD", "Ijamhuri ya Hidemokrasi ya Hukongo");
    namesMap.put("CF", "Ijamhuri ya Afrika ya Pagati");
    namesMap.put("CG", "Hukongo");
    namesMap.put("CH", "Huuswisi");
    namesMap.put("CI", "Hukodivaa");
    namesMap.put("CK", "Ifisima fya Kook");
    namesMap.put("CL", "Huchile");
    namesMap.put("CM", "Hukameruni");
    namesMap.put("CN", "Huchina");
    namesMap.put("CO", "Hukolombia");
    namesMap.put("CR", "Hukostarika");
    namesMap.put("CU", "Hukuba");
    namesMap.put("CV", "Hukepuvede");
    namesMap.put("CY", "Hukuprosi");
    namesMap.put("CZ", "Ijamhuri ya Cheki");
    namesMap.put("DE", "Huujerumani");
    namesMap.put("DJ", "Hujibuti");
    namesMap.put("DK", "Hudenmaki");
    namesMap.put("DM", "Hudominika");
    namesMap.put("DO", "Ijamhuri ya Hudominika");
    namesMap.put("DZ", "Hualjelia");
    namesMap.put("EC", "Huekwado");
    namesMap.put("EE", "Huestonia");
    namesMap.put("EG", "Humisri");
    namesMap.put("ER", "Hueritrea");
    namesMap.put("ES", "Huhispania");
    namesMap.put("ET", "Huuhabeshi");
    namesMap.put("FI", "Huufini");
    namesMap.put("FJ", "Hufiji");
    namesMap.put("FK", "Ifisima fya Falkland");
    namesMap.put("FM", "Humikronesia");
    namesMap.put("FR", "Huufaransa");
    namesMap.put("GA", "Hugaboni");
    namesMap.put("GB", "Huuingereza");
    namesMap.put("GD", "Hugrenada");
    namesMap.put("GE", "Hujojia");
    namesMap.put("GF", "Hugwiyana ya Huufaransa");
    namesMap.put("GH", "Hughana");
    namesMap.put("GI", "Hujiblalta");
    namesMap.put("GL", "Hujinlandi");
    namesMap.put("GM", "Hugambia");
    namesMap.put("GN", "Hujine");
    namesMap.put("GP", "Hugwadelupe");
    namesMap.put("GQ", "Huginekweta");
    namesMap.put("GR", "Huugiliki");
    namesMap.put("GT", "Hugwatemala");
    namesMap.put("GU", "Hugwam");
    namesMap.put("GW", "Huginebisau");
    namesMap.put("GY", "Huguyana");
    namesMap.put("HN", "Huhondulasi");
    namesMap.put("HR", "Hukorasia");
    namesMap.put("HT", "Huhaiti");
    namesMap.put("HU", "Huhungalia");
    namesMap.put("ID", "Huindonesia");
    namesMap.put("IE", "Huayalandi");
    namesMap.put("IL", "Huislaheli");
    namesMap.put("IN", "Huindia");
    namesMap.put("IO", "Ulubali lwa Hubahari ya Hindi lwa Huingereza");
    namesMap.put("IQ", "Huilaki");
    namesMap.put("IR", "Huuajemi");
    namesMap.put("IS", "Huaislandi");
    namesMap.put("IT", "Huitalia");
    namesMap.put("JM", "Hujamaika");
    namesMap.put("JO", "Huyolodani");
    namesMap.put("JP", "Hujapani");
    namesMap.put("KE", "Hukenya");
    namesMap.put("KG", "Hukiligizistani");
    namesMap.put("KH", "Hukambodia");
    namesMap.put("KI", "Hukilibati");
    namesMap.put("KM", "Hukomoro");
    namesMap.put("KN", "Husantakitzi na Hunevis");
    namesMap.put("KP", "Hukolea Kaskazini");
    namesMap.put("KR", "Hukolea Kusini");
    namesMap.put("KW", "Hukuwaiti");
    namesMap.put("KY", "Ifisima fya Kayman");
    namesMap.put("KZ", "Hukazakistani");
    namesMap.put("LA", "Hulaosi");
    namesMap.put("LB", "Hulebanoni");
    namesMap.put("LC", "Husantalusia");
    namesMap.put("LI", "Hulishenteni");
    namesMap.put("LK", "Husirilanka");
    namesMap.put("LR", "Hulibelia");
    namesMap.put("LS", "Hulesoto");
    namesMap.put("LT", "Hulitwania");
    namesMap.put("LU", "Hulasembagi");
    namesMap.put("LV", "Hulativia");
    namesMap.put("LY", "Hulibiya");
    namesMap.put("MA", "Humoloko");
    namesMap.put("MC", "Humonako");
    namesMap.put("MD", "Humoldova");
    namesMap.put("MG", "Hubukini");
    namesMap.put("MH", "Ifisima fya Marshal");
    namesMap.put("MK", "Humasedonia");
    namesMap.put("ML", "Humali");
    namesMap.put("MM", "Humyama");
    namesMap.put("MN", "Humongolia");
    namesMap.put("MP", "Ifisima fya Mariana fya Hukaskazini");
    namesMap.put("MQ", "Humartiniki");
    namesMap.put("MR", "Humolitania");
    namesMap.put("MS", "Humontserrati");
    namesMap.put("MT", "Humalta");
    namesMap.put("MU", "Humolisi");
    namesMap.put("MV", "Humodivu");
    namesMap.put("MW", "Humalawi");
    namesMap.put("MX", "Humeksiko");
    namesMap.put("MY", "Humalesia");
    namesMap.put("MZ", "Humusumbiji");
    namesMap.put("NA", "Hunamibia");
    namesMap.put("NC", "Hunyukaledonia");
    namesMap.put("NE", "Hunijeli");
    namesMap.put("NF", "Ihisima sha Norfok");
    namesMap.put("NG", "Hunijelia");
    namesMap.put("NI", "Hunikaragwa");
    namesMap.put("NL", "Huuholanzi");
    namesMap.put("NO", "Hunolwe");
    namesMap.put("NP", "Hunepali");
    namesMap.put("NR", "Hunauru");
    namesMap.put("NU", "Huniue");
    namesMap.put("NZ", "Hunyuzilandi");
    namesMap.put("OM", "Huomani");
    namesMap.put("PA", "Hupanama");
    namesMap.put("PE", "Hupelu");
    namesMap.put("PF", "Hupolinesia ya Huufaransa");
    namesMap.put("PG", "Hupapua");
    namesMap.put("PH", "Hufilipino");
    namesMap.put("PK", "Hupakistani");
    namesMap.put("PL", "Hupolandi");
    namesMap.put("PM", "Husantapieri na Humikeloni");
    namesMap.put("PN", "Hupitkaini");
    namesMap.put("PR", "Hupwetoriko");
    namesMap.put("PS", "Ulubali lwa Magharibi nu Gaza wa Hupalestina");
    namesMap.put("PT", "Huuleno");
    namesMap.put("PW", "Hupalau");
    namesMap.put("PY", "Hupalagwai");
    namesMap.put("QA", "Hukatali");
    namesMap.put("RE", "Huliyunioni");
    namesMap.put("RO", "Hulomania");
    namesMap.put("RU", "Huulusi");
    namesMap.put("RW", "Hulwanda");
    namesMap.put("SA", "Husaudi");
    namesMap.put("SB", "Ifisima fya Solomon");
    namesMap.put("SC", "Hushelisheli");
    namesMap.put("SD", "Husudani");
    namesMap.put("SE", "Huuswidi");
    namesMap.put("SG", "Husingapoo");
    namesMap.put("SH", "Husantahelena");
    namesMap.put("SI", "Huslovenia");
    namesMap.put("SK", "Huslovakia");
    namesMap.put("SL", "Husiela Lioni");
    namesMap.put("SM", "Husamalino");
    namesMap.put("SN", "Husenegali");
    namesMap.put("SO", "Husomalia");
    namesMap.put("SR", "Husurinamu");
    namesMap.put("ST", "Husaotome na Huprinsipe");
    namesMap.put("SV", "Huelsavado");
    namesMap.put("SY", "Husilia");
    namesMap.put("SZ", "Huuswazi");
    namesMap.put("TC", "Ifisima fya Turki na Kaiko");
    namesMap.put("TD", "Huchadi");
    namesMap.put("TG", "Hutogo");
    namesMap.put("TH", "Hutailandi");
    namesMap.put("TJ", "Hutajikistani");
    namesMap.put("TK", "Hutokelau");
    namesMap.put("TL", "Hutimori ya Mashariki");
    namesMap.put("TM", "Huuturukimenistani");
    namesMap.put("TN", "Hutunisia");
    namesMap.put("TO", "Hutonga");
    namesMap.put("TR", "Huuturuki");
    namesMap.put("TT", "Hutrinad na Hutobago");
    namesMap.put("TV", "Hutuvalu");
    namesMap.put("TW", "Hutaiwani");
    namesMap.put("TZ", "Hutanzania");
    namesMap.put("UA", "Huukraini");
    namesMap.put("UG", "Huuganda");
    namesMap.put("US", "Humalekani");
    namesMap.put("UY", "Huulugwai");
    namesMap.put("UZ", "Huuzibekistani");
    namesMap.put("VA", "Huvatikani");
    namesMap.put("VC", "Husantavisenti na Hugrenadini");
    namesMap.put("VE", "Huvenezuela");
    namesMap.put("VG", "Ifisima fya Virgin fya Huingereza");
    namesMap.put("VI", "Ifisima fya Virgin fya Humelekani");
    namesMap.put("VN", "Huvietinamu");
    namesMap.put("VU", "Huvanuatu");
    namesMap.put("WF", "Huwalis na Hufutuna");
    namesMap.put("WS", "Husamoa");
    namesMap.put("YE", "Huyemeni");
    namesMap.put("YT", "Humayotte");
    namesMap.put("ZA", "Huafrika iya Hukusini");
    namesMap.put("ZM", "Huzambia");
    namesMap.put("ZW", "Huzimbabwe");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Huandola",
        "AE": "Hufalme dza Hihalabu",
        "AF": "Huafuganistani",
        "AG": "Huantigua na Hubarubuda",
        "AI": "Huanguila",
        "AL": "Hualbania",
        "AM": "Huamenia",
        "AO": "Huangola",
        "AR": "Huajendina",
        "AS": "Husamoa ya Humalekani",
        "AT": "Huastlia",
        "AU": "Huaustlalia",
        "AW": "Hualuba",
        "AZ": "Huazabajani",
        "BA": "Hubosinia na Huhezegovina",
        "BB": "Hubabadosi",
        "BD": "Hubangaladeshi",
        "BE": "Huubelgiji",
        "BF": "Hubukinafaso",
        "BG": "Hubulgaria",
        "BH": "Hubahaleni",
        "BI": "Huburundi",
        "BJ": "Hubenini",
        "BM": "Hubelmuda",
        "BN": "Hubrunei",
        "BO": "Hubolivia",
        "BR": "Hublazili",
        "BS": "Hubahama",
        "BT": "Hubutani",
        "BW": "Hubotiswana",
        "BY": "Hubelalusi",
        "BZ": "Hubelize",
        "CA": "Hukanada",
        "CD": "Ijamhuri ya Hidemokrasi ya Hukongo",
        "CF": "Ijamhuri ya Afrika ya Pagati",
        "CG": "Hukongo",
        "CH": "Huuswisi",
        "CI": "Hukodivaa",
        "CK": "Ifisima fya Kook",
        "CL": "Huchile",
        "CM": "Hukameruni",
        "CN": "Huchina",
        "CO": "Hukolombia",
        "CR": "Hukostarika",
        "CU": "Hukuba",
        "CV": "Hukepuvede",
        "CY": "Hukuprosi",
        "CZ": "Ijamhuri ya Cheki",
        "DE": "Huujerumani",
        "DJ": "Hujibuti",
        "DK": "Hudenmaki",
        "DM": "Hudominika",
        "DO": "Ijamhuri ya Hudominika",
        "DZ": "Hualjelia",
        "EC": "Huekwado",
        "EE": "Huestonia",
        "EG": "Humisri",
        "ER": "Hueritrea",
        "ES": "Huhispania",
        "ET": "Huuhabeshi",
        "FI": "Huufini",
        "FJ": "Hufiji",
        "FK": "Ifisima fya Falkland",
        "FM": "Humikronesia",
        "FR": "Huufaransa",
        "GA": "Hugaboni",
        "GB": "Huuingereza",
        "GD": "Hugrenada",
        "GE": "Hujojia",
        "GF": "Hugwiyana ya Huufaransa",
        "GH": "Hughana",
        "GI": "Hujiblalta",
        "GL": "Hujinlandi",
        "GM": "Hugambia",
        "GN": "Hujine",
        "GP": "Hugwadelupe",
        "GQ": "Huginekweta",
        "GR": "Huugiliki",
        "GT": "Hugwatemala",
        "GU": "Hugwam",
        "GW": "Huginebisau",
        "GY": "Huguyana",
        "HN": "Huhondulasi",
        "HR": "Hukorasia",
        "HT": "Huhaiti",
        "HU": "Huhungalia",
        "ID": "Huindonesia",
        "IE": "Huayalandi",
        "IL": "Huislaheli",
        "IN": "Huindia",
        "IO": "Ulubali lwa Hubahari ya Hindi lwa Huingereza",
        "IQ": "Huilaki",
        "IR": "Huuajemi",
        "IS": "Huaislandi",
        "IT": "Huitalia",
        "JM": "Hujamaika",
        "JO": "Huyolodani",
        "JP": "Hujapani",
        "KE": "Hukenya",
        "KG": "Hukiligizistani",
        "KH": "Hukambodia",
        "KI": "Hukilibati",
        "KM": "Hukomoro",
        "KN": "Husantakitzi na Hunevis",
        "KP": "Hukolea Kaskazini",
        "KR": "Hukolea Kusini",
        "KW": "Hukuwaiti",
        "KY": "Ifisima fya Kayman",
        "KZ": "Hukazakistani",
        "LA": "Hulaosi",
        "LB": "Hulebanoni",
        "LC": "Husantalusia",
        "LI": "Hulishenteni",
        "LK": "Husirilanka",
        "LR": "Hulibelia",
        "LS": "Hulesoto",
        "LT": "Hulitwania",
        "LU": "Hulasembagi",
        "LV": "Hulativia",
        "LY": "Hulibiya",
        "MA": "Humoloko",
        "MC": "Humonako",
        "MD": "Humoldova",
        "MG": "Hubukini",
        "MH": "Ifisima fya Marshal",
        "MK": "Humasedonia",
        "ML": "Humali",
        "MM": "Humyama",
        "MN": "Humongolia",
        "MP": "Ifisima fya Mariana fya Hukaskazini",
        "MQ": "Humartiniki",
        "MR": "Humolitania",
        "MS": "Humontserrati",
        "MT": "Humalta",
        "MU": "Humolisi",
        "MV": "Humodivu",
        "MW": "Humalawi",
        "MX": "Humeksiko",
        "MY": "Humalesia",
        "MZ": "Humusumbiji",
        "NA": "Hunamibia",
        "NC": "Hunyukaledonia",
        "NE": "Hunijeli",
        "NF": "Ihisima sha Norfok",
        "NG": "Hunijelia",
        "NI": "Hunikaragwa",
        "NL": "Huuholanzi",
        "NO": "Hunolwe",
        "NP": "Hunepali",
        "NR": "Hunauru",
        "NU": "Huniue",
        "NZ": "Hunyuzilandi",
        "OM": "Huomani",
        "PA": "Hupanama",
        "PE": "Hupelu",
        "PF": "Hupolinesia ya Huufaransa",
        "PG": "Hupapua",
        "PH": "Hufilipino",
        "PK": "Hupakistani",
        "PL": "Hupolandi",
        "PM": "Husantapieri na Humikeloni",
        "PN": "Hupitkaini",
        "PR": "Hupwetoriko",
        "PS": "Ulubali lwa Magharibi nu Gaza wa Hupalestina",
        "PT": "Huuleno",
        "PW": "Hupalau",
        "PY": "Hupalagwai",
        "QA": "Hukatali",
        "RE": "Huliyunioni",
        "RO": "Hulomania",
        "RU": "Huulusi",
        "RW": "Hulwanda",
        "SA": "Husaudi",
        "SB": "Ifisima fya Solomon",
        "SC": "Hushelisheli",
        "SD": "Husudani",
        "SE": "Huuswidi",
        "SG": "Husingapoo",
        "SH": "Husantahelena",
        "SI": "Huslovenia",
        "SK": "Huslovakia",
        "SL": "Husiela Lioni",
        "SM": "Husamalino",
        "SN": "Husenegali",
        "SO": "Husomalia",
        "SR": "Husurinamu",
        "ST": "Husaotome na Huprinsipe",
        "SV": "Huelsavado",
        "SY": "Husilia",
        "SZ": "Huuswazi",
        "TC": "Ifisima fya Turki na Kaiko",
        "TD": "Huchadi",
        "TG": "Hutogo",
        "TH": "Hutailandi",
        "TJ": "Hutajikistani",
        "TK": "Hutokelau",
        "TL": "Hutimori ya Mashariki",
        "TM": "Huuturukimenistani",
        "TN": "Hutunisia",
        "TO": "Hutonga",
        "TR": "Huuturuki",
        "TT": "Hutrinad na Hutobago",
        "TV": "Hutuvalu",
        "TW": "Hutaiwani",
        "TZ": "Hutanzania",
        "UA": "Huukraini",
        "UG": "Huuganda",
        "US": "Humalekani",
        "UY": "Huulugwai",
        "UZ": "Huuzibekistani",
        "VA": "Huvatikani",
        "VC": "Husantavisenti na Hugrenadini",
        "VE": "Huvenezuela",
        "VG": "Ifisima fya Virgin fya Huingereza",
        "VI": "Ifisima fya Virgin fya Humelekani",
        "VN": "Huvietinamu",
        "VU": "Huvanuatu",
        "WF": "Huwalis na Hufutuna",
        "WS": "Husamoa",
        "YE": "Huyemeni",
        "YT": "Humayotte",
        "ZA": "Huafrika iya Hukusini",
        "ZM": "Huzambia",
        "ZW": "Huzimbabwe"
    };
  }-*/;
}
