/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.v7.data.util.sqlcontainer.connection;

import com.vaadin.v7.data.util.sqlcontainer.connection.JDBCConnectionPool;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

@Deprecated
public class SimpleJDBCConnectionPool
implements JDBCConnectionPool {
    private int initialConnections = 5;
    private int maxConnections = 20;
    private String driverName;
    private String connectionUri;
    private String userName;
    private String password;
    private transient Set<Connection> availableConnections;
    private transient Set<Connection> reservedConnections;
    private boolean initialized;

    public SimpleJDBCConnectionPool(String driverName, String connectionUri, String userName, String password) throws SQLException {
        if (driverName == null) {
            throw new IllegalArgumentException("JDBC driver class name must be given.");
        }
        if (connectionUri == null) {
            throw new IllegalArgumentException("Database connection URI must be given.");
        }
        if (userName == null) {
            throw new IllegalArgumentException("Database username must be given.");
        }
        if (password == null) {
            throw new IllegalArgumentException("Database password must be given.");
        }
        this.driverName = driverName;
        this.connectionUri = connectionUri;
        this.userName = userName;
        this.password = password;
        try {
            Class.forName(driverName).newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException("Specified JDBC Driver: " + driverName + " - initialization failed.", ex);
        }
    }

    public SimpleJDBCConnectionPool(String driverName, String connectionUri, String userName, String password, int initialConnections, int maxConnections) throws SQLException {
        this(driverName, connectionUri, userName, password);
        this.initialConnections = initialConnections;
        this.maxConnections = maxConnections;
    }

    private void initializeConnections() throws SQLException {
        this.availableConnections = new HashSet<Connection>(this.initialConnections);
        this.reservedConnections = new HashSet<Connection>(this.initialConnections);
        for (int i = 0; i < this.initialConnections; ++i) {
            this.availableConnections.add(this.createConnection());
        }
        this.initialized = true;
    }

    @Override
    public synchronized Connection reserveConnection() throws SQLException {
        if (!this.initialized) {
            this.initializeConnections();
        }
        if (this.availableConnections.isEmpty()) {
            if (this.reservedConnections.size() < this.maxConnections) {
                this.availableConnections.add(this.createConnection());
            } else {
                throw new SQLException("Connection limit has been reached.");
            }
        }
        Connection c = this.availableConnections.iterator().next();
        this.availableConnections.remove(c);
        this.reservedConnections.add(c);
        return c;
    }

    @Override
    public synchronized void releaseConnection(Connection conn) {
        if (conn == null || !this.initialized) {
            return;
        }
        try {
            if (!conn.getAutoCommit()) {
                conn.rollback();
            }
        }
        catch (SQLException e) {
            try {
                conn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.reservedConnections.remove(conn);
            return;
        }
        this.reservedConnections.remove(conn);
        this.availableConnections.add(conn);
    }

    private Connection createConnection() throws SQLException {
        Connection c = DriverManager.getConnection(this.connectionUri, this.userName, this.password);
        c.setAutoCommit(false);
        if (this.driverName.toLowerCase(Locale.ROOT).contains("mysql")) {
            try {
                Statement s = c.createStatement();
                s.execute("SET SESSION sql_mode = 'ANSI'");
                s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return c;
    }

    @Override
    public void destroy() {
        for (Connection c : this.availableConnections) {
            try {
                c.close();
            }
            catch (SQLException sQLException) {}
        }
        for (Connection c : this.reservedConnections) {
            try {
                c.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.initialized = false;
        out.defaultWriteObject();
    }
}

