/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.header.AddressParametersHeader;
import io.pkts.packet.sip.header.CSeqHeader;
import io.pkts.packet.sip.header.CallIdHeader;
import io.pkts.packet.sip.header.ContactHeader;
import io.pkts.packet.sip.header.ContentLengthHeader;
import io.pkts.packet.sip.header.ContentTypeHeader;
import io.pkts.packet.sip.header.ExpiresHeader;
import io.pkts.packet.sip.header.FromHeader;
import io.pkts.packet.sip.header.MaxForwardsHeader;
import io.pkts.packet.sip.header.RecordRouteHeader;
import io.pkts.packet.sip.header.RouteHeader;
import io.pkts.packet.sip.header.ToHeader;
import io.pkts.packet.sip.header.ViaHeader;
import io.pkts.packet.sip.header.impl.SipHeaderImpl;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipParser;
import java.io.IOException;

public interface SipHeader
extends Cloneable {
    public static final String CANNOT_CAST_HEADER_OF_TYPE = "Cannot cast header of type ";
    public static final String UNABLE_TO_PARSE_OUT_THE_HEADER_NAME_DUE_TO_UNDERLYING_IO_EXCEPTION = "Unable to parse out the header name due to underlying IOException";

    public Buffer getName();

    default public String getNameStr() {
        return this.getName().toString();
    }

    default public boolean is(String name) {
        if (name == null || name.isEmpty()) {
            return false;
        }
        return Buffers.wrap((String)name).equals((Object)this.getName());
    }

    default public boolean is(Buffer name) {
        if (name == null) {
            return false;
        }
        return name.equals((Object)this.getName());
    }

    public Buffer getValue();

    public void verify() throws SipParseException;

    public void getBytes(Buffer var1);

    default public int getBufferSize() {
        return this.getName().capacity() + 2 + this.getValue().getReadableBytes();
    }

    public SipHeader clone();

    public static SipHeader frame(Buffer value) throws SipParseException {
        PreConditions.assertNotEmpty(value, "The value of the header cannot be null or the empty buffer");
        return SipParser.nextHeader(value);
    }

    public static SipHeader frame(String value) throws SipParseException {
        return SipParser.nextHeader(Buffers.wrap((String)value));
    }

    public static SipHeader create(String name, String value) {
        PreConditions.assertNotEmpty(name, "The name of the header cannot be empty");
        return new SipHeaderImpl(Buffers.wrap((String)name), Buffers.wrap((String)value));
    }

    public SipHeader ensure();

    default public boolean isAddressParametersHeader() {
        return false;
    }

    default public boolean isSystemHeader() {
        return this.isToHeader() || this.isFromHeader() || this.isViaHeader() || this.isContactHeader() || this.isRouteHeader() || this.isRecordRouteHeader() || this.isCSeqHeader() || this.isMaxForwardsHeader();
    }

    default public boolean isFromHeader() {
        Buffer m = this.getName();
        try {
            if (m.getReadableBytes() == 4) {
                return !(m.getByte(0) != 70 && m.getByte(0) != 102 || m.getByte(1) != 114 && m.getByte(1) != 82 || m.getByte(2) != 111 && m.getByte(2) != 79 || m.getByte(3) != 109 && m.getByte(3) != 77);
            }
            if (m.getReadableBytes() == 1) {
                return m.getByte(0) == 70 || m.getByte(0) == 102;
            }
        }
        catch (IOException e) {
            throw new SipParseException(0, UNABLE_TO_PARSE_OUT_THE_HEADER_NAME_DUE_TO_UNDERLYING_IO_EXCEPTION, e);
        }
        return false;
    }

    default public FromHeader toFromHeader() {
        throw new ClassCastException(CANNOT_CAST_HEADER_OF_TYPE + this.getClass().getName() + " to type " + FromHeader.class.getName());
    }

    default public boolean isToHeader() {
        Buffer m = this.getName();
        try {
            if (m.getReadableBytes() == 2) {
                return !(m.getByte(0) != 84 && m.getByte(0) != 116 || m.getByte(1) != 111 && m.getByte(1) != 79);
            }
            if (m.getReadableBytes() == 1) {
                return m.getByte(0) == 84 || m.getByte(0) == 116;
            }
        }
        catch (IOException e) {
            throw new SipParseException(0, UNABLE_TO_PARSE_OUT_THE_HEADER_NAME_DUE_TO_UNDERLYING_IO_EXCEPTION, e);
        }
        return false;
    }

    default public ToHeader toToHeader() {
        throw new ClassCastException(CANNOT_CAST_HEADER_OF_TYPE + this.getClass().getName() + " to type " + ToHeader.class.getName());
    }

    default public boolean isContactHeader() {
        Buffer m = this.getName();
        try {
            if (m.getReadableBytes() == 7) {
                return !(m.getByte(0) != 67 && m.getByte(0) != 99 || m.getByte(1) != 111 && m.getByte(1) != 79 || m.getByte(2) != 110 && m.getByte(2) != 78 || m.getByte(3) != 116 && m.getByte(3) != 84 || m.getByte(4) != 97 && m.getByte(4) != 65 || m.getByte(5) != 99 && m.getByte(5) != 67 || m.getByte(6) != 116 && m.getByte(6) != 84);
            }
            if (m.getReadableBytes() == 1) {
                return m.getByte(0) == 77 || m.getByte(0) == 109;
            }
        }
        catch (IOException e) {
            throw new SipParseException(0, UNABLE_TO_PARSE_OUT_THE_HEADER_NAME_DUE_TO_UNDERLYING_IO_EXCEPTION, e);
        }
        return false;
    }

    default public ContactHeader toContactHeader() {
        throw new ClassCastException(CANNOT_CAST_HEADER_OF_TYPE + this.getClass().getName() + " to type " + ContactHeader.class.getName());
    }

    default public boolean isSubjectHeader() {
        Buffer m = this.getName();
        try {
            if (m.getReadableBytes() == 7) {
                return !(m.getByte(0) != 83 && m.getByte(0) != 115 || m.getByte(1) != 117 && m.getByte(1) != 85 || m.getByte(2) != 98 && m.getByte(2) != 66 || m.getByte(3) != 106 && m.getByte(3) != 74 || m.getByte(4) != 101 && m.getByte(4) != 69 || m.getByte(5) != 99 && m.getByte(5) != 67 || m.getByte(6) != 116 && m.getByte(6) != 84);
            }
        }
        catch (IOException e) {
            throw new SipParseException(0, UNABLE_TO_PARSE_OUT_THE_HEADER_NAME_DUE_TO_UNDERLYING_IO_EXCEPTION, e);
        }
        return false;
    }

    default public boolean isCallIdHeader() {
        Buffer m = this.getName();
        try {
            if (m.getReadableBytes() == 7) {
                return !(m.getByte(0) != 67 && m.getByte(0) != 99 || m.getByte(1) != 97 && m.getByte(1) != 65 || m.getByte(2) != 108 && m.getByte(2) != 76 || m.getByte(3) != 108 && m.getByte(3) != 76 || m.getByte(4) != 45 || m.getByte(5) != 73 && m.getByte(5) != 105 || m.getByte(6) != 68 && m.getByte(6) != 100);
            }
            if (m.getReadableBytes() == 1) {
                return m.getByte(0) == 73 || m.getByte(0) == 105;
            }
        }
        catch (IOException e) {
            throw new SipParseException(0, UNABLE_TO_PARSE_OUT_THE_HEADER_NAME_DUE_TO_UNDERLYING_IO_EXCEPTION, e);
        }
        return false;
    }

    default public CallIdHeader toCallIdHeader() {
        throw new ClassCastException(CANNOT_CAST_HEADER_OF_TYPE + this.getClass().getName() + " to type " + CallIdHeader.class.getName());
    }

    default public boolean isRouteHeader() {
        Buffer m = this.getName();
        if (m.getReadableBytes() == 5) {
            try {
                return !(m.getByte(0) != 82 && m.getByte(0) != 114 || m.getByte(1) != 111 && m.getByte(1) != 79 || m.getByte(2) != 117 && m.getByte(2) != 85 || m.getByte(3) != 116 && m.getByte(3) != 84 || m.getByte(4) != 101 && m.getByte(4) != 69);
            }
            catch (IOException e) {
                throw new SipParseException(0, UNABLE_TO_PARSE_OUT_THE_HEADER_NAME_DUE_TO_UNDERLYING_IO_EXCEPTION, e);
            }
        }
        return false;
    }

    default public boolean isRecordRouteHeader() {
        Buffer m = this.getName();
        if (m.getReadableBytes() == 12) {
            try {
                return !(m.getByte(0) != 82 && m.getByte(0) != 114 || m.getByte(1) != 101 && m.getByte(1) != 69 || m.getByte(2) != 99 && m.getByte(2) != 67 || m.getByte(3) != 111 && m.getByte(3) != 79 || m.getByte(4) != 114 && m.getByte(4) != 82 || m.getByte(5) != 100 && m.getByte(5) != 68 || m.getByte(6) != 45 || m.getByte(7) != 82 && m.getByte(7) != 114 || m.getByte(8) != 111 && m.getByte(8) != 79 || m.getByte(9) != 117 && m.getByte(9) != 85 || m.getByte(10) != 116 && m.getByte(10) != 84 || m.getByte(11) != 101 && m.getByte(11) != 69);
            }
            catch (IOException e) {
                throw new SipParseException(0, UNABLE_TO_PARSE_OUT_THE_HEADER_NAME_DUE_TO_UNDERLYING_IO_EXCEPTION, e);
            }
        }
        return false;
    }

    default public RecordRouteHeader toRecordRouteHeader() {
        throw new ClassCastException(CANNOT_CAST_HEADER_OF_TYPE + this.getClass().getName() + " to type " + RecordRouteHeader.class.getName());
    }

    default public RouteHeader toRouteHeader() {
        throw new ClassCastException(CANNOT_CAST_HEADER_OF_TYPE + this.getClass().getName() + " to type " + RouteHeader.class.getName());
    }

    default public boolean isContentLengthHeader() {
        Buffer m = this.getName();
        try {
            if (m.getReadableBytes() == 14) {
                return !(m.getByte(0) != 67 && m.getByte(0) != 99 || m.getByte(1) != 111 && m.getByte(1) != 79 || m.getByte(2) != 110 && m.getByte(2) != 78 || m.getByte(3) != 116 && m.getByte(3) != 84 || m.getByte(4) != 101 && m.getByte(4) != 69 || m.getByte(5) != 110 && m.getByte(5) != 78 || m.getByte(6) != 116 && m.getByte(6) != 84 || m.getByte(7) != 45 || m.getByte(8) != 76 && m.getByte(8) != 108 || m.getByte(9) != 101 && m.getByte(9) != 69 || m.getByte(10) != 110 && m.getByte(10) != 78 || m.getByte(11) != 103 && m.getByte(11) != 71 || m.getByte(12) != 116 && m.getByte(12) != 84 || m.getByte(13) != 104 && m.getByte(13) != 72);
            }
            if (m.getReadableBytes() == 1) {
                return m.getByte(0) == 76 || m.getByte(0) == 108;
            }
        }
        catch (IOException e) {
            throw new SipParseException(0, UNABLE_TO_PARSE_OUT_THE_HEADER_NAME_DUE_TO_UNDERLYING_IO_EXCEPTION, e);
        }
        return false;
    }

    default public ContentLengthHeader toContentLengthHeader() {
        throw new ClassCastException(CANNOT_CAST_HEADER_OF_TYPE + this.getClass().getName() + " to type " + ContentLengthHeader.class.getName());
    }

    default public boolean isContentTypeHeader() {
        Buffer m = this.getName();
        try {
            if (m.getReadableBytes() == 12) {
                return !(m.getByte(0) != 67 && m.getByte(0) != 99 || m.getByte(1) != 111 && m.getByte(1) != 79 || m.getByte(2) != 110 && m.getByte(2) != 78 || m.getByte(3) != 116 && m.getByte(3) != 84 || m.getByte(4) != 101 && m.getByte(4) != 69 || m.getByte(5) != 110 && m.getByte(5) != 78 || m.getByte(6) != 116 && m.getByte(6) != 84 || m.getByte(7) != 45 || m.getByte(8) != 84 && m.getByte(8) != 116 || m.getByte(9) != 121 && m.getByte(9) != 89 || m.getByte(10) != 112 && m.getByte(10) != 80 || m.getByte(11) != 101 && m.getByte(11) != 69);
            }
            if (m.getReadableBytes() == 1) {
                return m.getByte(0) == 67 || m.getByte(0) == 99;
            }
        }
        catch (IOException e) {
            throw new SipParseException(0, UNABLE_TO_PARSE_OUT_THE_HEADER_NAME_DUE_TO_UNDERLYING_IO_EXCEPTION, e);
        }
        return false;
    }

    default public ContentTypeHeader toContentTypeHeader() {
        throw new ClassCastException(CANNOT_CAST_HEADER_OF_TYPE + this.getClass().getName() + " to type " + ContentTypeHeader.class.getName());
    }

    default public boolean isExpiresHeader() {
        Buffer m = this.getName();
        try {
            if (m.getReadableBytes() == 7) {
                return !(m.getByte(0) != 69 && m.getByte(0) != 101 || m.getByte(1) != 120 && m.getByte(1) != 88 || m.getByte(2) != 112 && m.getByte(2) != 80 || m.getByte(3) != 105 && m.getByte(3) != 73 || m.getByte(4) != 114 && m.getByte(4) != 82 || m.getByte(5) != 101 && m.getByte(5) != 69 || m.getByte(6) != 115 && m.getByte(6) != 83);
            }
        }
        catch (IOException e) {
            throw new SipParseException(0, UNABLE_TO_PARSE_OUT_THE_HEADER_NAME_DUE_TO_UNDERLYING_IO_EXCEPTION, e);
        }
        return false;
    }

    default public ExpiresHeader toExpiresHeader() {
        throw new ClassCastException(CANNOT_CAST_HEADER_OF_TYPE + this.getClass().getName() + " to type " + ExpiresHeader.class.getName());
    }

    default public boolean isCSeqHeader() {
        Buffer m = this.getName();
        try {
            if (m.getReadableBytes() == 4) {
                return !(m.getByte(0) != 67 && m.getByte(0) != 99 || m.getByte(1) != 83 && m.getByte(1) != 115 || m.getByte(2) != 101 && m.getByte(2) != 69 || m.getByte(3) != 113 && m.getByte(3) != 81);
            }
        }
        catch (IOException e) {
            throw new SipParseException(0, UNABLE_TO_PARSE_OUT_THE_HEADER_NAME_DUE_TO_UNDERLYING_IO_EXCEPTION, e);
        }
        return false;
    }

    default public CSeqHeader toCSeqHeader() {
        throw new ClassCastException(CANNOT_CAST_HEADER_OF_TYPE + this.getClass().getName() + " to type " + CSeqHeader.class.getName());
    }

    default public boolean isMaxForwardsHeader() {
        Buffer m = this.getName();
        if (m.getReadableBytes() == 12) {
            try {
                return !(m.getByte(0) != 77 && m.getByte(0) != 109 || m.getByte(1) != 97 && m.getByte(1) != 65 || m.getByte(2) != 120 && m.getByte(2) != 88 || m.getByte(3) != 45 || m.getByte(4) != 70 && m.getByte(4) != 102 || m.getByte(5) != 111 && m.getByte(5) != 79 || m.getByte(6) != 114 && m.getByte(6) != 82 || m.getByte(7) != 119 && m.getByte(7) != 87 || m.getByte(8) != 97 && m.getByte(8) != 65 || m.getByte(9) != 114 && m.getByte(9) != 82 || m.getByte(10) != 100 && m.getByte(10) != 68 || m.getByte(11) != 115 && m.getByte(11) != 83);
            }
            catch (IOException e) {
                throw new SipParseException(0, UNABLE_TO_PARSE_OUT_THE_HEADER_NAME_DUE_TO_UNDERLYING_IO_EXCEPTION, e);
            }
        }
        return false;
    }

    default public ViaHeader toViaHeader() {
        throw new ClassCastException(CANNOT_CAST_HEADER_OF_TYPE + this.getClass().getName() + " to type " + ViaHeader.class.getName());
    }

    default public boolean isViaHeader() {
        Buffer m = this.getName();
        try {
            if (m.getReadableBytes() == 3) {
                return !(m.getByte(0) != 86 && m.getByte(0) != 118 || m.getByte(1) != 105 && m.getByte(1) != 73 || m.getByte(2) != 97 && m.getByte(2) != 65);
            }
            if (m.getReadableBytes() == 1) {
                return m.getByte(0) == 86 || m.getByte(0) == 118;
            }
        }
        catch (IOException e) {
            throw new SipParseException(0, UNABLE_TO_PARSE_OUT_THE_HEADER_NAME_DUE_TO_UNDERLYING_IO_EXCEPTION, e);
        }
        return false;
    }

    default public MaxForwardsHeader toMaxForwardsHeader() {
        throw new ClassCastException(CANNOT_CAST_HEADER_OF_TYPE + this.getClass().getName() + " to type " + MaxForwardsHeader.class.getName());
    }

    default public AddressParametersHeader toAddressParametersHeader() throws ClassCastException {
        throw new ClassCastException(CANNOT_CAST_HEADER_OF_TYPE + this.getClass().getName() + " to type " + AddressParametersHeader.class.getName());
    }

    public Builder copy();

    public static interface Builder<H extends SipHeader> {
        public Builder<H> withValue(Buffer var1);

        default public Builder<H> withValue(String value) {
            return this.withValue(Buffers.wrap((String)value));
        }

        public H build() throws SipParseException;
    }
}

