/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.providers.action;

import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.xml.bind.JAXB;
import org.opennms.netmgt.search.api.Contexts;
import org.opennms.netmgt.search.api.QueryUtils;
import org.opennms.netmgt.search.api.SearchContext;
import org.opennms.netmgt.search.api.SearchProvider;
import org.opennms.netmgt.search.api.SearchQuery;
import org.opennms.netmgt.search.api.SearchResult;
import org.opennms.netmgt.search.api.SearchResultItem;
import org.opennms.netmgt.search.providers.action.Action;
import org.opennms.netmgt.search.providers.action.Actions;
import org.opennms.netmgt.search.providers.action.PrincipalCacheKey;

public class StaticActionSearchProvider
implements SearchProvider {
    private final LoadingCache<PrincipalCacheKey, Actions> cache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(5L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<PrincipalCacheKey, Actions>(){

        public Actions load(PrincipalCacheKey key) throws Exception {
            Path etc = Paths.get(System.getProperty("opennms.home"), "etc", "search-actions.xml");
            Actions actions = (Actions)JAXB.unmarshal((File)etc.toFile(), Actions.class);
            return actions;
        }
    });

    public SearchContext getContext() {
        return Contexts.Action;
    }

    public SearchResult query(SearchQuery query) {
        Objects.requireNonNull(query.getPrincipal());
        PrincipalCacheKey cacheKey = new PrincipalCacheKey(query);
        Actions actions = (Actions)this.cache.getUnchecked((Object)cacheKey);
        String input = query.getInput();
        List allItemsForUser = actions.getActions().stream().filter(action -> {
            if (action.getPrivilegedRoles().isEmpty()) return true;
            if (!action.getPrivilegedRoles().stream().anyMatch(arg_0 -> ((SearchQuery)query).isUserInRole(arg_0))) return false;
            return true;
        }).filter(action -> QueryUtils.matches((String)action.getLabel(), (String)input) || QueryUtils.matches(action.getAliases(), (String)input)).sorted(Comparator.comparing(Action::getLabel)).map(action -> {
            SearchResultItem searchResultItem = new SearchResultItem();
            if (QueryUtils.matches((String)action.getLabel(), (String)input)) {
                searchResultItem.setLabel(action.getLabel());
            } else {
                searchResultItem.setLabel(QueryUtils.getFirstMatch(action.getAliases(), (String)input));
            }
            searchResultItem.setUrl(action.getUrl());
            searchResultItem.setIdentifier(action.getUrl());
            if (!Strings.isNullOrEmpty((String)action.getIcon())) {
                searchResultItem.setIcon(action.getIcon());
            }
            if (action.getWeight() != 0) {
                searchResultItem.setWeight(action.getWeight());
            } else if (action.getPrivilegedRoles().contains("ROLE_ADMIN")) {
                searchResultItem.setWeight(10);
            }
            return searchResultItem;
        }).collect(Collectors.toList());
        List searchResultItems = QueryUtils.shrink(allItemsForUser, (int)query.getMaxResults());
        SearchResult searchResult = new SearchResult(Contexts.Action).withMore(allItemsForUser, (Collection)searchResultItems).withResults(searchResultItems);
        return searchResult;
    }
}

