/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.ticketer.jira;

import com.atlassian.jira.rest.client.api.JiraRestClient;
import com.atlassian.jira.rest.client.api.domain.BasicIssue;
import com.atlassian.jira.rest.client.api.domain.CimFieldInfo;
import com.atlassian.jira.rest.client.api.domain.CimProject;
import com.atlassian.jira.rest.client.api.domain.Comment;
import com.atlassian.jira.rest.client.api.domain.FieldSchema;
import com.atlassian.jira.rest.client.api.domain.Issue;
import com.atlassian.jira.rest.client.api.domain.Transition;
import com.atlassian.jira.rest.client.api.domain.input.IssueInputBuilder;
import com.atlassian.jira.rest.client.api.domain.input.TransitionInput;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.opennms.api.integration.ticketing.Plugin;
import org.opennms.api.integration.ticketing.PluginException;
import org.opennms.api.integration.ticketing.Ticket;
import org.opennms.core.mate.api.EntityScopeProvider;
import org.opennms.core.mate.api.Interpolator;
import org.opennms.core.mate.api.Scope;
import org.opennms.netmgt.ticketer.jira.Config;
import org.opennms.netmgt.ticketer.jira.FieldMapperRegistry;
import org.opennms.netmgt.ticketer.jira.JiraClientUtils;
import org.opennms.netmgt.ticketer.jira.JiraConnectionFactory;
import org.opennms.netmgt.ticketer.jira.cache.Cache;
import org.opennms.netmgt.ticketer.jira.cache.TimeoutRefreshPolicy;
import org.opennms.netmgt.ticketer.jira.fieldmapper.FieldMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraTicketerPlugin
implements Plugin {
    private static final Logger LOG = LoggerFactory.getLogger(JiraTicketerPlugin.class);
    private final Cache<List<CimProject>> fieldInfoCache;
    private final LoadingCache<FieldSchema, FieldMapper> fieldMapFunctionCache;
    private static EntityScopeProvider entityScopeProvider;

    public JiraTicketerPlugin(EntityScopeProvider entityScopeProvider) {
        JiraTicketerPlugin.entityScopeProvider = entityScopeProvider;
        Long cacheReloadTime = this.getConfig().getCacheReloadTime();
        if (cacheReloadTime == null || cacheReloadTime < 0L) {
            LOG.warn("Cache Reload time was set to {} ms. Negative or null values are not supported. Setting to 5 minutes.", (Object)cacheReloadTime);
            cacheReloadTime = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.MINUTES);
        }
        this.fieldMapFunctionCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(cacheReloadTime.longValue(), TimeUnit.MILLISECONDS).build((CacheLoader)new CacheLoader<FieldSchema, FieldMapper>(){

            public FieldMapper load(FieldSchema schema) throws Exception {
                FieldMapperRegistry fieldMapperRegistry = new FieldMapperRegistry(JiraTicketerPlugin.this.getConfig().getProperties());
                return fieldMapperRegistry.lookup(schema);
            }
        });
        this.fieldInfoCache = new Cache<List>(() -> {
            try (JiraRestClient client = this.getConnection();){
                List<CimProject> list = JiraClientUtils.getIssueMetaData(client, "projects.issuetypes.fields", this.getConfig().getIssueTypeId(), this.getConfig().getProjectKey());
                return list;
            }
        }, new TimeoutRefreshPolicy(cacheReloadTime, TimeUnit.NANOSECONDS));
    }

    protected JiraRestClient getConnection() throws PluginException {
        Config config = this.getConfig();
        return JiraConnectionFactory.createConnection(config.getHost(), config.getUsername(), config.getPassword());
    }

    public Ticket get(String ticketId) throws PluginException {
        Ticket ticket;
        block8: {
            JiraRestClient client = this.getConnection();
            try {
                ticket = this.getInternal(ticketId, client);
                if (client == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new PluginException((Throwable)e);
                }
            }
            client.close();
        }
        return ticket;
    }

    private Ticket getInternal(String ticketId, JiraRestClient jira) throws PluginException {
        Issue issue;
        try {
            issue = (Issue)jira.getIssueClient().getIssue(ticketId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new PluginException("Failed to get issue with id: " + ticketId, (Throwable)e);
        }
        if (issue != null) {
            Ticket ticket = new Ticket();
            ticket.setId(issue.getKey());
            ticket.setModificationTimestamp(String.valueOf(issue.getUpdateDate().toDate().getTime()));
            ticket.setSummary(issue.getSummary());
            ticket.setDetails(issue.getDescription());
            ticket.setState(this.getStateFromStatusName(issue.getStatus().getName()));
            return ticket;
        }
        return null;
    }

    private Ticket.State getStateFromStatusName(String ticketStatusName) {
        HashMap<Ticket.State, List<String>> ticketStateToJiraStatusMap = new HashMap<Ticket.State, List<String>>();
        ticketStateToJiraStatusMap.put(Ticket.State.OPEN, this.getConfig().getOpenStatus());
        ticketStateToJiraStatusMap.put(Ticket.State.CLOSED, this.getConfig().getCloseStatus());
        ticketStateToJiraStatusMap.put(Ticket.State.CANCELLED, this.getConfig().getCancelStatus());
        for (Map.Entry entry : ticketStateToJiraStatusMap.entrySet()) {
            HashSet knownStateIds = Sets.newHashSet((Iterable)((Iterable)entry.getValue()));
            if (!knownStateIds.contains(ticketStatusName)) continue;
            return (Ticket.State)entry.getKey();
        }
        return Ticket.State.OPEN;
    }

    public static Config getConfig(EntityScopeProvider entityScopeProvider) {
        return new Config(JiraTicketerPlugin.getProperties(entityScopeProvider));
    }

    private Config getConfig() {
        return JiraTicketerPlugin.getConfig(entityScopeProvider);
    }

    private static Properties getProperties(EntityScopeProvider entityScopeProvider) {
        File home = new File(System.getProperty("opennms.home"));
        File etc = new File(home, "etc");
        File config = new File(etc, "jira.properties");
        Properties props = new Properties();
        try (FileInputStream in = new FileInputStream(config);){
            props.load(in);
        }
        catch (IOException e) {
            LOG.error("Unable to load {} ignoring.", (Object)config, (Object)e);
        }
        Scope scope = entityScopeProvider.getScopeForScv();
        Properties interpolatedProperties = new Properties();
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            interpolatedProperties.put(entry.getKey(), Interpolator.interpolate((String)((String)entry.getValue()), (Scope)scope).output);
        }
        LOG.debug("Loaded user: {}", (Object)interpolatedProperties.getProperty("jira.username"));
        LOG.debug("Loaded type: {}", (Object)interpolatedProperties.getProperty("jira.type"));
        return interpolatedProperties;
    }

    public void saveOrUpdate(Ticket ticket) throws PluginException {
        try (JiraRestClient client = this.getConnection();){
            this.saveOrUpdateInternal(ticket, client);
        }
        catch (IOException e) {
            throw new PluginException((Throwable)e);
        }
    }

    private void saveOrUpdateInternal(Ticket ticket, JiraRestClient jira) throws PluginException {
        Config config = this.getConfig();
        if (ticket.getId() == null || ticket.getId().equals("")) {
            BasicIssue createdIssue;
            IssueInputBuilder builder = new IssueInputBuilder(config.getProjectKey(), config.getIssueTypeId());
            builder.setReporterName(config.getUsername());
            builder.setSummary(ticket.getSummary());
            builder.setDescription(ticket.getDetails());
            this.populateFields(ticket, builder);
            try {
                createdIssue = (BasicIssue)jira.getIssueClient().createIssue(builder.build()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new PluginException("Failed to create issue.", (Throwable)e);
            }
            LOG.info("created ticket " + createdIssue);
            ticket.setId(createdIssue.getKey());
        } else {
            Iterable transitions;
            Issue issue;
            LOG.info("Received ticket: {}", (Object)ticket.getId());
            try {
                issue = (Issue)jira.getIssueClient().getIssue(ticket.getId()).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new PluginException("Failed to get issue with id:" + ticket.getId(), (Throwable)e);
            }
            try {
                transitions = (Iterable)jira.getIssueClient().getTransitions(issue).get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new PluginException("Failed to get transitions for issue with id:" + issue.getId(), (Throwable)e);
            }
            if (Ticket.State.CLOSED.equals((Object)ticket.getState())) {
                Comment comment = Comment.valueOf((String)"Issue resolved by OpenNMS.");
                for (Transition transition : transitions) {
                    if (!config.getResolveTransitionName().equals(transition.getName())) continue;
                    LOG.info("Resolving ticket {}", (Object)ticket.getId());
                    try {
                        jira.getIssueClient().transition(issue, new TransitionInput(transition.getId(), comment)).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new PluginException("Failed to get resolve issue with id:" + issue.getId(), (Throwable)e);
                    }
                    return;
                }
                LOG.warn("Could not resolve ticket {}, no '{}' operation available.", (Object)ticket.getId(), (Object)this.getConfig().getResolveTransitionName());
            } else if (Ticket.State.OPEN.equals((Object)ticket.getState())) {
                Comment comment = Comment.valueOf((String)"Issue reopened by OpenNMS.");
                for (Transition transition : transitions) {
                    if (!this.getConfig().getReopentransitionName().equals(transition.getName())) continue;
                    LOG.info("Reopening ticket {}", (Object)ticket.getId());
                    try {
                        jira.getIssueClient().transition(issue, new TransitionInput(transition.getId(), comment)).get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        throw new PluginException("Failed to reopen issue with id:" + issue.getId(), (Throwable)e);
                    }
                    return;
                }
                LOG.warn("Could not reopen ticket {}, no '{}' operation available.", (Object)ticket.getId(), (Object)this.getConfig().getReopentransitionName());
            }
        }
    }

    private void populateFields(Ticket ticket, IssueInputBuilder builder) {
        List requiredFieldsNotSet;
        if (!ticket.hasAttributes()) {
            return;
        }
        ArrayList populatedFields = Lists.newArrayList();
        Collection<CimFieldInfo> fields = this.getFields();
        block2: for (Map.Entry eachEntry : ticket.getAttributes().entrySet()) {
            if (Strings.isNullOrEmpty((String)((String)eachEntry.getValue()))) continue;
            for (CimFieldInfo eachField : fields) {
                if (!((String)eachEntry.getKey()).equals(eachField.getId())) continue;
                try {
                    String attributeValue = (String)eachEntry.getValue();
                    Object mappedFieldValue = ((FieldMapper)this.fieldMapFunctionCache.get((Object)eachField.getSchema())).mapToFieldValue(eachField.getId(), eachField.getSchema(), attributeValue);
                    builder.setFieldValue(eachField.getId(), mappedFieldValue);
                    populatedFields.add(eachField.getId());
                    continue block2;
                }
                catch (Exception ex) {
                    LOG.error("Could not convert attribute (id={}, value={}) to jira field value. Ignoring attribute.", new Object[]{eachField.getId(), eachEntry.getValue(), ex});
                }
            }
        }
        if (populatedFields.size() != ticket.getAttributes().size()) {
            for (String eachKey : ticket.getAttributes().keySet()) {
                if (populatedFields.contains(eachKey)) continue;
                LOG.warn("Ticket attribute '{}' is defined, but was not mapped to a (custom) field in JIRA. Attribute is skipped.", (Object)eachKey);
            }
        }
        if (!(requiredFieldsNotSet = fields.stream().filter(CimFieldInfo::isRequired).filter(f -> !populatedFields.contains(f)).collect(Collectors.toList())).isEmpty()) {
            String missingFields = requiredFieldsNotSet.stream().map(f -> String.format("id: %s, name: %s", f.getId(), f.getName())).collect(Collectors.joining(", "));
            LOG.warn("Not all required (custom) jira fields have been set. The following are unset: {}", (Object)missingFields);
        }
    }

    private Collection<CimFieldInfo> getFields() {
        try {
            return JiraClientUtils.getFields(this.fieldInfoCache.get());
        }
        catch (Exception ex) {
            LOG.error("Error while retrieving (custom) field definitions from JIRA.", (Throwable)ex);
            return new ArrayList<CimFieldInfo>();
        }
    }

    public EntityScopeProvider getEntityScopeProvider() {
        return entityScopeProvider;
    }

    public void setEntityScopeProvider(EntityScopeProvider entityScopeProvider) {
        JiraTicketerPlugin.entityScopeProvider = entityScopeProvider;
    }
}

