/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.google.common.base.Strings;
import java.io.Closeable;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.message.BasicHeader;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.core.web.HttpClientWrapper;
import org.opennms.core.web.HttpClientWrapperConfigHelper;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.support.ParameterSubstitutingMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpPostMonitor
extends ParameterSubstitutingMonitor {
    private static final int DEFAULT_PORT = 80;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    public static final String DEFAULT_MIMETYPE = "text/xml";
    public static final String DEFAULT_CHARSET = StandardCharsets.UTF_8.name();
    public static final String DEFAULT_URI = "/";
    public static final String DEFAULT_SCHEME = "http";
    public static final boolean DEFAULT_SSLFILTER = false;
    public static final String PARAMETER_SCHEME = "scheme";
    public static final String PARAMETER_PORT = "port";
    public static final String PARAMETER_URI = "uri";
    public static final String PARAMETER_PAYLOAD = "payload";
    public static final String PARAMETER_MIMETYPE = "mimetype";
    public static final String PARAMETER_CHARSET = "charset";
    public static final String PARAMETER_BANNER = "banner";
    public static final String PARAMETER_SSLFILTER = "usesslfilter";
    public static final String PARAMETER_SSLFILER = "usesslfiler";
    public static final String PARAMETER_USERNAME = "auth-username";
    public static final String PARAMETER_PASSWORD = "auth-password";
    private static final Logger LOG = LoggerFactory.getLogger(HttpPostMonitor.class);
    private static final Pattern HEADER_PATTERN = Pattern.compile("header[0-9]+$");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        tracker = new TimeoutTracker(parameters, 0, 3000);
        port = ParameterMap.getKeyedInteger(parameters, (String)"port", (int)80);
        strURI = HttpPostMonitor.resolveKeyedString(parameters, (String)"uri", (String)"/");
        strUser = HttpPostMonitor.resolveKeyedString(parameters, (String)"auth-username", null);
        strPasswd = HttpPostMonitor.resolveKeyedString(parameters, (String)"auth-password", null);
        strBannerMatch = HttpPostMonitor.resolveKeyedString(parameters, (String)"banner", null);
        strScheme = ParameterMap.getKeyedString(parameters, (String)"scheme", (String)"http");
        strPayload = ParameterMap.getKeyedString(parameters, (String)"payload", null);
        strMimetype = ParameterMap.getKeyedString(parameters, (String)"mimetype", (String)"text/xml");
        strCharset = ParameterMap.getKeyedString(parameters, (String)"charset", (String)HttpPostMonitor.DEFAULT_CHARSET);
        boolSSLFilter = ParameterMap.getKeyedBoolean(parameters, (String)"usesslfilter", (boolean)false);
        boolSSLFiler = ParameterMap.getKeyedBoolean(parameters, (String)"usesslfiler", (boolean)false);
        ipAddr = svc.getAddress();
        hostAddress = InetAddressUtils.str((InetAddress)ipAddr);
        HttpPostMonitor.LOG.debug("poll: address = {}, port = {}, {}", new Object[]{hostAddress, port, tracker});
        serviceStatus = PollStatus.unavailable();
        tracker.reset();
        while (tracker.shouldRetry() != false) {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                if (serviceStatus.isAvailable() != false) return serviceStatus;
                                clientWrapper = null;
                                tracker.startAttempt();
                                clientWrapper = HttpClientWrapper.create().setConnectionTimeout(Integer.valueOf(tracker.getSoTimeout())).setSocketTimeout(Integer.valueOf(tracker.getSoTimeout())).setRetries(Integer.valueOf(0));
                                if (boolSSLFilter || boolSSLFiler) {
                                    clientWrapper.trustSelfSigned(strScheme);
                                }
                                if (strUser != null && strPasswd != null) {
                                    clientWrapper.addBasicCredentials(strUser, strPasswd);
                                }
                                HttpClientWrapperConfigHelper.setUseSystemProxyIfDefined((HttpClientWrapper)clientWrapper, parameters);
                                try {
                                    postReq = new StringEntity(strPayload, ContentType.create((String)strMimetype, (String)strCharset));
                                }
                                catch (UnsupportedCharsetException e) {
                                    serviceStatus = PollStatus.unavailable((String)("Unsupported encoding encountered while constructing POST body " + e));
                                    IOUtils.closeQuietly((Closeable)clientWrapper);
                                    return serviceStatus;
                                }
                                ub = new URIBuilder();
                                ub.setScheme(strScheme);
                                ub.setHost(hostAddress);
                                ub.setPort(port);
                                ub.setPath(strURI);
                                HttpPostMonitor.LOG.debug("HttpPostMonitor: Constructed URL is {}", (Object)ub);
                                post = new HttpPost(ub.build());
                                for (String key : parameters.keySet()) {
                                    if (!HttpPostMonitor.HEADER_PATTERN.matcher(key).matches()) continue;
                                    header = this.getHeader(ParameterMap.getKeyedString(parameters, (String)key, null));
                                    if (Strings.isNullOrEmpty((String)header.getName())) {
                                        HttpPostMonitor.LOG.debug("Ignoring header with empty name (value='{}')", (Object)header.getValue());
                                        continue;
                                    }
                                    post.setHeader(header);
                                    HttpPostMonitor.LOG.debug("Using header '{}'", (Object)(header.getName() + ": " + header.getValue()));
                                }
                                post.setEntity((HttpEntity)postReq);
                                response = clientWrapper.execute((HttpUriRequest)post);
                                HttpPostMonitor.LOG.debug("HttpPostMonitor: Status Line is {}", (Object)response.getStatusLine());
                                if (response.getStatusLine().getStatusCode() <= 399) break block18;
                                HttpPostMonitor.LOG.info("HttpPostMonitor: Got response status code {}", (Object)response.getStatusLine().getStatusCode());
                                HttpPostMonitor.LOG.debug("HttpPostMonitor: Received server response: {}", (Object)response.getStatusLine());
                                HttpPostMonitor.LOG.debug("HttpPostMonitor: Failing on bad status code");
                                serviceStatus = PollStatus.unavailable((String)("HTTP(S) Status code " + response.getStatusLine().getStatusCode()));
                                IOUtils.closeQuietly((Closeable)clientWrapper);
                                return serviceStatus;
                            }
                            HttpPostMonitor.LOG.debug("HttpPostMonitor: Response code is valid");
                            responseTime = tracker.elapsedTimeInMillis();
                            entity = response.getEntity();
                            responseStream = entity.getContent();
                            Strresponse = IOUtils.toString((InputStream)responseStream);
                            if (Strresponse != null) break block19;
                            IOUtils.closeQuietly((Closeable)clientWrapper);
                            break block22;
                        }
                        HttpPostMonitor.LOG.debug("HttpPostMonitor: banner = {}", (Object)Strresponse);
                        HttpPostMonitor.LOG.debug("HttpPostMonitor: responseTime= {}ms", (Object)responseTime);
                        if (Strings.isNullOrEmpty((String)strBannerMatch) || !strBannerMatch.startsWith("~")) ** GOTO lbl91
                        if (Strresponse.matches(strBannerMatch.substring(1))) break block20;
                        serviceStatus = PollStatus.unavailable((String)("Banner does not match Regex '" + strBannerMatch + "'"));
                        IOUtils.closeQuietly((Closeable)clientWrapper);
                        return serviceStatus;
                    }
                    try {
                        serviceStatus = PollStatus.available((Double)responseTime);
                        break block21;
lbl91:
                        // 1 sources

                        if (Strresponse.indexOf(strBannerMatch) > -1) {
                            serviceStatus = PollStatus.available((Double)responseTime);
                            break block21;
                        }
                        serviceStatus = PollStatus.unavailable((String)("Did not find expected Text '" + strBannerMatch + "'"));
                    }
                    catch (URISyntaxException e) {
                        reason = "URISyntaxException for URI: " + strURI + " " + e.getMessage();
                        HttpPostMonitor.LOG.debug(reason, (Throwable)e);
                        serviceStatus = PollStatus.unavailable((String)reason);
                        {
                            catch (Throwable var28_32) {
                                IOUtils.closeQuietly(clientWrapper);
                                throw var28_32;
                            }
                        }
                        IOUtils.closeQuietly((Closeable)clientWrapper);
                        return serviceStatus;
                        catch (Exception e) {
                            reason = "Exception: " + e.getMessage();
                            HttpPostMonitor.LOG.debug(reason, (Throwable)e);
                            serviceStatus = PollStatus.unavailable((String)reason);
                            IOUtils.closeQuietly((Closeable)clientWrapper);
                            return serviceStatus;
                        }
                    }
                    IOUtils.closeQuietly((Closeable)clientWrapper);
                    return serviceStatus;
                }
                IOUtils.closeQuietly((Closeable)clientWrapper);
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }

    private Header getHeader(String header) {
        if (Strings.isNullOrEmpty((String)header)) {
            throw new ParseException("Header is null or empty");
        }
        String[] arr = header.split(":");
        if (arr.length != 2) {
            throw new ParseException("Invalid header: '" + header + "'");
        }
        return new BasicHeader(arr[0].trim(), arr[1].trim());
    }
}

