/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.container.web.bridge.proxy.trackers;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletContext;
import org.opennms.container.web.bridge.proxy.ProxyFilter;
import org.opennms.container.web.bridge.proxy.handlers.RequestHandler;
import org.opennms.container.web.bridge.proxy.handlers.ResourceInfo;
import org.opennms.container.web.bridge.proxy.handlers.ResourceRequestHandler;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ResourceTracker
extends ServiceTracker {
    private final ProxyFilter proxyFilter;
    private final ServletContext servletContext;
    private Map<ServiceReference, RequestHandler> requestHandlerMap = new HashMap<ServiceReference, RequestHandler>();

    public ResourceTracker(BundleContext context, ServletContext servletContext, ProxyFilter proxyFilter) throws InvalidSyntaxException {
        super(context, context.createFilter(String.format("(&(%s=*)(%s=*))", "osgi.http.whiteboard.resource.pattern", "osgi.http.whiteboard.resource.prefix")), null);
        this.proxyFilter = Objects.requireNonNull(proxyFilter);
        this.servletContext = Objects.requireNonNull(servletContext);
    }

    public Object addingService(ServiceReference reference) {
        Object resource = super.addingService(reference);
        ResourceInfo resourceInfo = new ResourceInfo(reference);
        if (!resourceInfo.isValid()) {
            this.servletContext.log(String.format("Resource is not valid. Property '%s' and '%s' must be defined", "osgi.http.whiteboard.resource.pattern", "osgi.http.whiteboard.resource.prefix"));
            return resource;
        }
        ResourceRequestHandler resourceRequestHandler = new ResourceRequestHandler(resourceInfo);
        this.requestHandlerMap.put(reference, resourceRequestHandler);
        this.proxyFilter.addRequestHandler(resourceRequestHandler);
        return resource;
    }

    public void removedService(ServiceReference reference, Object service) {
        super.removedService(reference, service);
        RequestHandler removedRequestHandler = this.requestHandlerMap.remove(reference);
        this.proxyFilter.removeRequestHandler(removedRequestHandler);
    }
}

