/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.dashboard.ui.dashboard;

import com.vaadin.event.dd.DragAndDropEvent;
import com.vaadin.event.dd.DropHandler;
import com.vaadin.event.dd.acceptcriteria.AcceptAll;
import com.vaadin.event.dd.acceptcriteria.AcceptCriterion;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Component;
import com.vaadin.ui.GridLayout;
import com.vaadin.ui.Panel;
import fi.jasoft.dragdroplayouts.DDGridLayout;
import fi.jasoft.dragdroplayouts.client.ui.LayoutDragMode;
import fi.jasoft.dragdroplayouts.events.LayoutBoundTransferable;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opennms.features.vaadin.dashboard.config.DashletSelector;
import org.opennms.features.vaadin.dashboard.model.Dashlet;
import org.opennms.features.vaadin.dashboard.model.DashletComponent;
import org.opennms.features.vaadin.dashboard.model.DashletSelectorAccess;
import org.opennms.features.vaadin.dashboard.model.DashletSpec;

public class DashboardBody
extends DDGridLayout {
    Map<Component, DashletComponent> m_displayDashlets;

    public DashboardBody() {
        this.setSizeFull();
        this.setMargin(true);
        this.setSpacing(true);
        this.setDragMode(LayoutDragMode.NONE);
        this.setDropHandler(new DropHandler(){

            public AcceptCriterion getAcceptCriterion() {
                return AcceptAll.get();
            }

            public void drop(DragAndDropEvent event) {
                DDGridLayout.GridLayoutTargetDetails details = (DDGridLayout.GridLayoutTargetDetails)event.getTargetDetails();
                LayoutBoundTransferable transferable = (LayoutBoundTransferable)event.getTransferable();
                int column = details.getOverColumn();
                int row = details.getOverRow();
                Component c = transferable.getComponent();
                if (DashboardBody.this.getComponent(column, row) == null) {
                    DashboardBody.this.removeComponent(c);
                    DashboardBody.this.addComponent(c, column, row);
                    DashboardBody.this.setComponentAlignment(c, Alignment.MIDDLE_CENTER);
                } else {
                    Component componentToBeSwapped = DashboardBody.this.getComponent(column, row);
                    GridLayout.Area area = DashboardBody.this.getComponentArea(c);
                    DashboardBody.this.removeComponent(c);
                    DashboardBody.this.removeComponent(componentToBeSwapped);
                    DashboardBody.this.addComponent(c, column, row);
                    DashboardBody.this.addComponent(componentToBeSwapped, area.getColumn1(), area.getRow1());
                    DashboardBody.this.setComponentAlignment(c, Alignment.MIDDLE_CENTER);
                    DashboardBody.this.setComponentAlignment(componentToBeSwapped, Alignment.MIDDLE_CENTER);
                }
            }
        });
        this.setShim(false);
    }

    private Dashlet getDashletInstance(DashletSpec dashletSpec) {
        DashletSelector dashletSelector = ((DashletSelectorAccess)this.getUI()).getDashletSelector();
        return dashletSelector.getDashletFactoryForName(dashletSpec.getDashletName()).newDashletInstance(dashletSpec);
    }

    private boolean suitableForDashboard(DashletSpec dashletSpec) {
        DashletSelector dashletSelector = ((DashletSelectorAccess)this.getUI()).getDashletSelector();
        return dashletSelector.getDashletFactoryForName(dashletSpec.getDashletName()).isSuitableForDashboard();
    }

    public void setDashletSpecs(List<DashletSpec> dashletSpecs) {
        this.m_displayDashlets = new HashMap<Component, DashletComponent>();
        boolean c = false;
        LinkedList<DashletSpec> dashboardSuitableDashlets = new LinkedList<DashletSpec>();
        if (dashletSpecs.size() == 0) {
            return;
        }
        for (DashletSpec dashletSpec : dashletSpecs) {
            if (!this.suitableForDashboard(dashletSpec)) continue;
            dashboardSuitableDashlets.add(dashletSpec);
        }
        if (dashboardSuitableDashlets.size() == 0) {
            return;
        }
        int columns = (int)Math.ceil(Math.sqrt(dashboardSuitableDashlets.size()));
        int rows = (int)Math.ceil((double)dashboardSuitableDashlets.size() / (double)columns);
        this.setColumns(columns);
        this.setRows(rows);
        int i = 0;
        this.removeAllComponents();
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < columns; ++x) {
                if (i >= dashboardSuitableDashlets.size()) continue;
                Dashlet dashlet = this.getDashletInstance((DashletSpec)dashboardSuitableDashlets.get(i));
                DashletComponent dashletComponent = dashlet.getDashboardComponent(this.getUI());
                this.m_displayDashlets.put(dashletComponent.getComponent(), dashletComponent);
                dashletComponent.refresh();
                String caption = dashlet.getName();
                if (dashlet.getDashletSpec().getTitle() != null && !"".equals(dashlet.getDashletSpec().getTitle())) {
                    caption = caption + ": " + dashlet.getDashletSpec().getTitle();
                }
                this.addComponent((Component)this.createPanel(dashletComponent.getComponent(), caption), x, y);
                ++i;
            }
        }
    }

    public void updateAll() {
        for (int y = 0; y < this.getRows(); ++y) {
            for (int x = 0; x < this.getColumns(); ++x) {
                Component component;
                Panel panel = (Panel)this.getComponent(x, y);
                if (panel == null || (component = panel.getContent()) == null) continue;
                this.m_displayDashlets.get(component).refresh();
            }
        }
    }

    private Panel createPanel(Component content, String caption) {
        Panel panel = new Panel();
        panel.setSizeFull();
        panel.setCaption(caption);
        panel.setContent(content);
        panel.addStyleName("novscroll");
        return panel;
    }
}

