/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.enlinkd.generator.protocol;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.opennms.core.utils.LldpUtils;
import org.opennms.enlinkd.generator.TopologyContext;
import org.opennms.enlinkd.generator.TopologyGenerator;
import org.opennms.enlinkd.generator.TopologySettings;
import org.opennms.enlinkd.generator.protocol.Protocol;
import org.opennms.enlinkd.generator.topology.PairGenerator;
import org.opennms.netmgt.enlinkd.model.LldpElement;
import org.opennms.netmgt.enlinkd.model.LldpLink;
import org.opennms.netmgt.model.OnmsNode;

public class LldpProtocol
extends Protocol {
    private final TopologyGenerator.Protocol protocol = TopologyGenerator.Protocol.lldp;
    private final Random ifindexRandomGenerator = new Random();

    public LldpProtocol(TopologySettings topologySettings, TopologyContext context) {
        super(topologySettings, context);
    }

    @Override
    public void createAndPersistProtocolSpecificEntities(List<OnmsNode> nodes) {
        List<LldpElement> elements = this.createElements(nodes);
        this.context.getTopologyPersister().persist(elements);
        List<LldpLink> links = this.createLinks(elements);
        this.context.getTopologyPersister().persist(links);
    }

    private List<LldpElement> createElements(List<OnmsNode> nodes) {
        ArrayList<LldpElement> elements = new ArrayList<LldpElement>();
        for (int i = 0; i < this.topologySettings.getAmountElements(); ++i) {
            OnmsNode node = nodes.get(i);
            String lLdpChassisId = "lLdpChassisId" + UUID.randomUUID();
            elements.add(this.createElement(node, lLdpChassisId));
        }
        return elements;
    }

    private LldpElement createElement(OnmsNode node, String lLdpChassisId) {
        LldpElement element = new LldpElement();
        element.setNode(node);
        element.setLldpChassisId(lLdpChassisId);
        element.setLldpChassisIdSubType(LldpUtils.LldpChassisIdSubType.LLDP_CHASSISID_SUBTYPE_CHASSISCOMPONENT);
        element.setLldpNodeLastPollTime(new Date());
        element.setLldpSysname("LldpSysname");
        return element;
    }

    private List<LldpLink> createLinks(List<LldpElement> elements) {
        PairGenerator<LldpElement> pairs = this.createPairGenerator(elements);
        ArrayList<LldpLink> links = new ArrayList<LldpLink>();
        for (int i = 0; i < this.topologySettings.getAmountLinks() / 2; ++i) {
            Pair<LldpElement, LldpElement> pair = pairs.next();
            LldpElement sourceElement = (LldpElement)pair.getLeft();
            LldpElement targetElement = (LldpElement)pair.getRight();
            LldpUtils.LldpPortIdSubType portIdSubType = LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_MACADDRESS;
            LldpUtils.LldpPortIdSubType portIdSubTypeRemote = LldpUtils.LldpPortIdSubType.LLDP_PORTID_SUBTYPE_MACADDRESS;
            int sourceIfIndex = (Integer)this.nodeIfIndexes.get(sourceElement.getNode().getId());
            int targetIfIndex = (Integer)this.nodeIfIndexes.get(targetElement.getNode().getId());
            String portId = sourceElement.getNode().getId() + "-" + sourceIfIndex;
            String portIdRemote = sourceElement.getNode().getId() + "-" + sourceIfIndex;
            LldpLink sourceLink = this.createLink(sourceElement.getNode(), portId, portIdSubType, portIdRemote, portIdSubTypeRemote, targetElement.getLldpChassisId(), sourceIfIndex);
            links.add(sourceLink);
            LldpLink targetLink = this.createLink(targetElement.getNode(), portIdRemote, portIdSubTypeRemote, portId, portIdSubType, sourceElement.getLldpChassisId(), targetIfIndex);
            links.add(targetLink);
            this.context.currentProgress(String.format("Linked node %s with node %s", sourceElement.getNode().getLabel(), targetElement.getNode().getLabel()));
        }
        return links;
    }

    private LldpLink createLink(OnmsNode node, String portId, LldpUtils.LldpPortIdSubType portIdSubType, String remotePortId, LldpUtils.LldpPortIdSubType remotePortIdSubType, String remoteChassisId, int ifIndex) {
        LldpLink link = new LldpLink();
        link.setLldpPortId(portId);
        link.setLldpPortIdSubType(portIdSubType);
        link.setLldpRemPortId(remotePortId);
        link.setLldpRemPortIdSubType(remotePortIdSubType);
        link.setLldpRemChassisId(remoteChassisId);
        link.setNode(node);
        link.setLldpPortIfindex(Integer.valueOf(ifIndex));
        link.setLldpRemChassisIdSubType(LldpUtils.LldpChassisIdSubType.LLDP_CHASSISID_SUBTYPE_CHASSISCOMPONENT);
        link.setLldpRemLocalPortNum(Integer.valueOf(this.ifindexRandomGenerator.nextInt(100000)));
        link.setLldpRemIndex(Integer.valueOf(this.ifindexRandomGenerator.nextInt(100000)));
        link.setLldpLinkLastPollTime(new Date());
        link.setLldpPortDescr("lldpportdescr");
        link.setLldpRemSysname("lldpRemSysname");
        link.setLldpPortDescr("lldpPortDescr");
        link.setLldpRemPortDescr("lldpRemPortDescr");
        return link;
    }

    @Override
    public TopologyGenerator.Protocol getProtocol() {
        return this.protocol;
    }
}

