/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.listeners;

import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.GlobalEventExecutor;
import io.netty.util.internal.SocketUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.opennms.netmgt.telemetry.api.receiver.GracefulShutdownListener;
import org.opennms.netmgt.telemetry.api.receiver.Parser;
import org.opennms.netmgt.telemetry.listeners.TcpParser;
import org.opennms.netmgt.telemetry.listeners.utils.NettyEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpListener
implements GracefulShutdownListener {
    private static final Logger LOG = LoggerFactory.getLogger(TcpListener.class);
    private final String name;
    private final TcpParser parser;
    private final Meter packetsReceived;
    private String host = null;
    private int port = 50000;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private ChannelFuture socketFuture;
    private ChannelGroup channels = new DefaultChannelGroup((EventExecutor)GlobalEventExecutor.INSTANCE);
    private Future<String> stopFuture;

    public TcpListener(String name, TcpParser parser, MetricRegistry metrics) {
        this.name = Objects.requireNonNull(name);
        this.parser = Objects.requireNonNull(parser);
        this.packetsReceived = metrics.meter(MetricRegistry.name((String)"listeners", (String[])new String[]{name, "packetsReceived"}));
    }

    public void start() throws InterruptedException {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        this.parser.start((ScheduledExecutorService)this.bossGroup);
        InetSocketAddress address = this.host != null ? SocketUtils.socketAddress((String)this.host, (int)this.port) : new InetSocketAddress(this.port);
        this.socketFuture = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) {
                final TcpParser.Handler session = TcpListener.this.parser.accept(ch.remoteAddress(), ch.localAddress());
                ch.pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                        TcpListener.this.packetsReceived.mark();
                        super.channelRead(ctx, msg);
                    }
                }}).addLast(new ChannelHandler[]{new ByteToMessageDecoder(){

                    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
                        session.parse(in).ifPresent(out::add);
                    }

                    public void channelActive(ChannelHandlerContext ctx) throws Exception {
                        super.channelActive(ctx);
                        session.active();
                    }

                    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                        super.channelInactive(ctx);
                        session.inactive();
                    }
                }}).addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<CompletableFuture<?>>(){

                    protected void channelRead0(ChannelHandlerContext ctx, CompletableFuture<?> future) throws Exception {
                        future.handle((result, ex) -> {
                            if (ex != null) {
                                ctx.fireExceptionCaught(ex);
                            }
                            return result;
                        });
                    }
                }}).addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                        LOG.warn("Invalid packet: {}", (Object)cause.getMessage());
                        LOG.debug("", cause);
                        session.inactive();
                        ctx.close();
                    }
                }});
            }

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                TcpListener.this.channels.add((Object)ctx.channel());
                super.channelActive(ctx);
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                TcpListener.this.channels.remove((Object)ctx.channel());
                super.channelInactive(ctx);
            }
        }).bind((SocketAddress)address).sync();
    }

    public void stop() throws InterruptedException {
        final NettyEventListener workerListener = new NettyEventListener("worker");
        final NettyEventListener bossListener = new NettyEventListener("boss");
        LOG.info("Disconnecting clients...");
        this.channels.close().awaitUninterruptibly();
        LOG.info("Closing worker group...");
        this.workerGroup.shutdownGracefully().addListener((GenericFutureListener)workerListener);
        LOG.info("Closing boss group...");
        this.bossGroup.shutdownGracefully().addListener((GenericFutureListener)bossListener);
        if (this.socketFuture != null) {
            LOG.info("Closing channel...");
            this.socketFuture.channel().close().sync();
            if (this.socketFuture.channel().parent() != null) {
                this.socketFuture.channel().parent().close().sync();
            }
        }
        LOG.info("Stopping parser...");
        if (this.parser != null) {
            this.parser.stop();
        }
        this.stopFuture = new Future<String>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }

            @Override
            public boolean isDone() {
                return workerListener.isDone() && bossListener.isDone();
            }

            @Override
            public String get() {
                return TcpListener.this.name + "[" + workerListener.getName() + ":" + workerListener.isDone() + "," + bossListener.getName() + ":" + bossListener.isDone() + "]";
            }

            @Override
            public String get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.get();
            }
        };
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return String.format("TCP %s:%s", this.host != null ? this.host : "*", this.port);
    }

    public Collection<? extends Parser> getParsers() {
        return Collections.singleton(this.parser);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Future getShutdownFuture() {
        return this.stopFuture;
    }
}

