/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.netmgt.enlinkd.service.api.BridgeForwardingTableEntry;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;

public class Dot1dTpFdbTableTracker
extends TableTracker {
    public static final SnmpObjId DOT1D_TP_FDB_ADDRESS_OID = SnmpObjId.get((String)".1.3.6.1.2.1.17.4.3.1.1");
    public static final SnmpObjId DOT1D_TP_FDB_PORT_OID = SnmpObjId.get((String)".1.3.6.1.2.1.17.4.3.1.2");
    public static final SnmpObjId DOT1D_TP_FDB_STATUS_OID = SnmpObjId.get((String)".1.3.6.1.2.1.17.4.3.1.3");
    public static final String DOT1D_TP_FDB_ADDRESS = "dot1dTpFdbAddress";
    public static final String DOT1D_TP_FDB_PORT = "dot1dTpFdbPort";
    public static final String DOT1D_TP_FDB_STATUS = "dot1dTpFdbStatus";
    public static final SnmpObjId[] ms_elemList = new SnmpObjId[]{DOT1D_TP_FDB_ADDRESS_OID, DOT1D_TP_FDB_PORT_OID, DOT1D_TP_FDB_STATUS_OID};

    public Dot1dTpFdbTableTracker() {
        super(ms_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new Dot1dTpFdbRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processDot1dTpFdbRow((Dot1dTpFdbRow)row);
    }

    public void processDot1dTpFdbRow(Dot1dTpFdbRow row) {
        System.out.printf("\t\t%s (%s)= %s \n", DOT1D_TP_FDB_ADDRESS_OID + "." + row.getInstance().toString(), DOT1D_TP_FDB_ADDRESS, row.getDot1dTpFdbAddress());
        System.out.printf("\t\t%s (%s)= %s \n", DOT1D_TP_FDB_PORT_OID + "." + row.getInstance().toString(), DOT1D_TP_FDB_PORT, row.getDot1dTpFdbPort());
        System.out.printf("\t\t%s (%s)= %s (%s)\n", DOT1D_TP_FDB_STATUS_OID + "." + row.getInstance().toString(), DOT1D_TP_FDB_STATUS, row.getDot1dTpFdbStatus(), BridgeForwardingTableEntry.BridgeDot1qTpFdbStatus.get((Integer)row.getDot1dTpFdbStatus()));
    }

    public static class Dot1dTpFdbRow
    extends SnmpRowResult {
        public Dot1dTpFdbRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
        }

        public String getDot1dTpFdbAddress() {
            if (this.getValue(DOT1D_TP_FDB_ADDRESS_OID) != null) {
                return this.getValue(DOT1D_TP_FDB_ADDRESS_OID).toHexString();
            }
            return null;
        }

        public Integer getDot1dTpFdbPort() {
            if (this.getValue(DOT1D_TP_FDB_PORT_OID) != null) {
                return this.getValue(DOT1D_TP_FDB_PORT_OID).toInt();
            }
            return null;
        }

        public Integer getDot1dTpFdbStatus() {
            if (this.getValue(DOT1D_TP_FDB_STATUS_OID) != null) {
                return this.getValue(DOT1D_TP_FDB_STATUS_OID).toInt();
            }
            return null;
        }

        public BridgeForwardingTableEntry getLink() {
            BridgeForwardingTableEntry link = new BridgeForwardingTableEntry();
            link.setBridgePort(this.getDot1dTpFdbPort());
            link.setMacAddress(this.getDot1dTpFdbAddress());
            if (this.getDot1dTpFdbStatus() != null) {
                link.setBridgeDot1qTpFdbStatus(BridgeForwardingTableEntry.BridgeDot1qTpFdbStatus.get((Integer)this.getDot1dTpFdbStatus()));
            }
            return link;
        }
    }
}

