/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.Type;
import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.model.OnmsNode;

@Entity
@Table(name="lldpLink")
@Filter(name="authorizedOnly", condition="exists (select distinct x.nodeid from node x join category_node cn on x.nodeid = cn.nodeid join category_group cg on cn.categoryId = cg.categoryId where x.nodeid = nodeid and cg.groupId in (:userGroups))")
public class LldpLink
implements Serializable {
    private static final long serialVersionUID = 3813247749765614567L;
    private Integer m_id;
    private OnmsNode m_node;
    private LldpUtils.LldpPortIdSubType m_lldpPortIdSubType;
    private Integer m_lldpRemLocalPortNum;
    private Integer m_lldpRemIndex;
    private Integer m_lldpPortIfindex;
    private String m_lldpPortId;
    private String m_lldpPortDescr;
    private String m_lldpRemChassisId;
    private String m_lldpRemSysname;
    private LldpUtils.LldpChassisIdSubType m_lldpRemChassisIdSubType;
    private LldpUtils.LldpPortIdSubType m_lldpRemPortIdSubType;
    private String m_lldpRemPortId;
    private String m_lldpRemPortDescr;
    private Date m_lldpLinkCreateTime = new Date();
    private Date m_lldpLinkLastPollTime;

    public LldpLink() {
    }

    public LldpLink(OnmsNode node, Integer lldpRemIndex, Integer lldpRemLocalPortNum, Integer portIfIndex, String portId, String portDescr, LldpUtils.LldpPortIdSubType portIdSubType, String remChassisId, String remSysname, LldpUtils.LldpChassisIdSubType remChassisIdSubType, String remPortId, LldpUtils.LldpPortIdSubType remPortIdSubType, String remPortDescr) {
        this.setNode(node);
        this.setLldpRemIndex(lldpRemIndex);
        this.setLldpRemLocalPortNum(lldpRemLocalPortNum);
        this.setLldpPortIfindex(portIfIndex);
        this.setLldpPortId(portId);
        this.setLldpPortDescr(portDescr);
        this.setLldpPortIdSubType(portIdSubType);
        this.setLldpRemChassisId(remChassisId);
        this.setLldpRemSysname(remSysname);
        this.setLldpRemChassisIdSubType(remChassisIdSubType);
        this.setLldpRemPortId(remPortId);
        this.setLldpRemPortIdSubType(remPortIdSubType);
        this.setLldpRemPortDescr(remPortDescr);
    }

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @Column(name="lldpRemLocalPortNum", nullable=false)
    public Integer getLldpRemLocalPortNum() {
        return this.m_lldpRemLocalPortNum;
    }

    public void setLldpRemLocalPortNum(Integer lldpRemLocalPortNum) {
        this.m_lldpRemLocalPortNum = lldpRemLocalPortNum;
    }

    @Column(name="lldpRemIndex", nullable=false)
    public Integer getLldpRemIndex() {
        return this.m_lldpRemIndex;
    }

    public void setLldpRemIndex(Integer lldpRemIndex) {
        this.m_lldpRemIndex = lldpRemIndex;
    }

    @Column(name="lldpPortIdSubType", nullable=false)
    @Type(type="org.opennms.netmgt.enlinkd.model.LldpPortIdSubTypeUserType")
    public LldpUtils.LldpPortIdSubType getLldpPortIdSubType() {
        return this.m_lldpPortIdSubType;
    }

    public void setLldpPortIdSubType(LldpUtils.LldpPortIdSubType lldpPortIdSubType) {
        this.m_lldpPortIdSubType = lldpPortIdSubType;
    }

    @Column(name="lldpPortId", length=256, nullable=false)
    public String getLldpPortId() {
        return this.m_lldpPortId;
    }

    public void setLldpPortId(String lldpPortId) {
        this.m_lldpPortId = lldpPortId;
    }

    @Column(name="lldpPortDescr", length=256, nullable=false)
    public String getLldpPortDescr() {
        return this.m_lldpPortDescr;
    }

    public void setLldpPortDescr(String lldpPortDescr) {
        this.m_lldpPortDescr = lldpPortDescr;
    }

    @Column(name="lldpPortIfindex")
    public Integer getLldpPortIfindex() {
        return this.m_lldpPortIfindex;
    }

    public void setLldpPortIfindex(Integer lldpPortIfindex) {
        this.m_lldpPortIfindex = lldpPortIfindex;
    }

    @Column(name="lldpRemChassisId", length=256, nullable=false)
    public String getLldpRemChassisId() {
        return this.m_lldpRemChassisId;
    }

    public void setLldpRemChassisId(String lldpRemChassisId) {
        this.m_lldpRemChassisId = lldpRemChassisId;
    }

    @Column(name="lldpRemSysname", length=256, nullable=false)
    public String getLldpRemSysname() {
        return this.m_lldpRemSysname;
    }

    public void setLldpRemSysname(String lldpRemSysname) {
        this.m_lldpRemSysname = lldpRemSysname;
    }

    @Column(name="lldpRemChassisIdSubType", nullable=false)
    @Type(type="org.opennms.netmgt.enlinkd.model.LldpChassisIdSubTypeUserType")
    public LldpUtils.LldpChassisIdSubType getLldpRemChassisIdSubType() {
        return this.m_lldpRemChassisIdSubType;
    }

    public void setLldpRemChassisIdSubType(LldpUtils.LldpChassisIdSubType lldpRemChassisIdSubType) {
        this.m_lldpRemChassisIdSubType = lldpRemChassisIdSubType;
    }

    @Column(name="lldpRemPortIdSubType", nullable=false)
    @Type(type="org.opennms.netmgt.enlinkd.model.LldpPortIdSubTypeUserType")
    public LldpUtils.LldpPortIdSubType getLldpRemPortIdSubType() {
        return this.m_lldpRemPortIdSubType;
    }

    public void setLldpRemPortIdSubType(LldpUtils.LldpPortIdSubType lldpRemPortIdSubType) {
        this.m_lldpRemPortIdSubType = lldpRemPortIdSubType;
    }

    @Column(name="lldpRemPortId", length=256, nullable=false)
    public String getLldpRemPortId() {
        return this.m_lldpRemPortId;
    }

    public void setLldpRemPortId(String lldpRemPortId) {
        this.m_lldpRemPortId = lldpRemPortId;
    }

    @Column(name="lldpRemPortDescr", length=256, nullable=false)
    public String getLldpRemPortDescr() {
        return this.m_lldpRemPortDescr;
    }

    public void setLldpRemPortDescr(String lldpRemPortDescr) {
        this.m_lldpRemPortDescr = lldpRemPortDescr;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lldpLinkCreateTime", nullable=false)
    public Date getLldpLinkCreateTime() {
        return this.m_lldpLinkCreateTime;
    }

    public void setLldpLinkCreateTime(Date lldpLinkCreateTime) {
        this.m_lldpLinkCreateTime = lldpLinkCreateTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="lldpLinkLastPollTime", nullable=false)
    public Date getLldpLinkLastPollTime() {
        return this.m_lldpLinkLastPollTime;
    }

    public void setLldpLinkLastPollTime(Date lldpLinkLastPollTime) {
        this.m_lldpLinkLastPollTime = lldpLinkLastPollTime;
    }

    public void merge(LldpLink link) {
        this.setLldpPortId(link.getLldpPortId());
        this.setLldpPortIdSubType(link.getLldpPortIdSubType());
        this.setLldpPortDescr(link.getLldpPortDescr());
        this.setLldpPortIfindex(link.getLldpPortIfindex());
        this.setLldpRemChassisId(link.getLldpRemChassisId());
        this.setLldpRemChassisIdSubType(link.getLldpRemChassisIdSubType());
        this.setLldpRemSysname(link.getLldpRemSysname());
        this.setLldpRemPortId(link.getLldpRemPortId());
        this.setLldpRemPortIdSubType(link.getLldpRemPortIdSubType());
        this.setLldpRemPortDescr(link.getLldpRemPortDescr());
        this.setLldpLinkLastPollTime(link.getLldpLinkCreateTime());
    }

    public String toString() {
        return "lldplink: nodeid:[" + this.getNode().getId() + "]. remLocalPortNum:[ " + this.getLldpRemLocalPortNum() + "]. remIndex:[ " + this.getLldpRemIndex() + "], ifindex:[" + this.getLldpPortIfindex() + "], port type/id:[" + LldpUtils.LldpPortIdSubType.getTypeString((Integer)this.getLldpPortIdSubType().getValue()) + "/" + this.getLldpPortId() + "], port descr:[" + this.getLldpPortDescr() + "], rem chassis type/id:[" + LldpUtils.LldpChassisIdSubType.getTypeString((Integer)this.getLldpRemChassisIdSubType().getValue()) + "/" + this.getLldpRemChassisId() + "], rem sysname:[" + this.getLldpRemSysname() + "], rem port type/id:[" + LldpUtils.LldpPortIdSubType.getTypeString((Integer)this.getLldpRemPortIdSubType().getValue()) + "/" + this.getLldpRemPortId() + "], rem port descr: [" + this.getLldpRemPortDescr() + "]";
    }
}

