/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.mail;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.validator.routines.EmailValidator;
import org.opennms.core.utils.StreamUtils;
import org.opennms.javamail.JavaMailer;
import org.opennms.javamail.JavaMailerException;
import org.opennms.web.servlet.MissingParameterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MailerServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(MailerServlet.class);
    private static final long serialVersionUID = -6241742874510146572L;
    protected static final String[] REQUIRED_FIELDS = new String[]{"sendto", "subject", "msg"};
    protected String redirectSuccess;
    protected EmailValidator emailValidator = EmailValidator.getInstance();

    public void init() throws ServletException {
        ServletConfig config = this.getServletConfig();
        this.redirectSuccess = config.getInitParameter("redirect.success");
        if (this.redirectSuccess == null) {
            throw new ServletException("Missing required init parameter: redirect.success");
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String sendto = request.getParameter("sendto");
        String subject = request.getParameter("subject");
        String msg = request.getParameter("msg");
        String username = request.getRemoteUser();
        LOG.debug("To: {}, Subject: {}, message: {}, username: {}", new Object[]{sendto, subject, msg, username});
        if (sendto == null) {
            throw new MissingParameterException("sendto", REQUIRED_FIELDS);
        }
        if (!this.emailValidator.isValid(sendto)) {
            throw new IllegalArgumentException("sendto is an invalid email address.");
        }
        if (subject == null) {
            throw new MissingParameterException("subject", REQUIRED_FIELDS);
        }
        if (msg == null) {
            throw new MissingParameterException("msg", REQUIRED_FIELDS);
        }
        try {
            JavaMailer mailer = new JavaMailer();
            mailer.setTo(sendto);
            mailer.setSubject(subject);
            mailer.setMessageText(msg);
            mailer.mailSend();
            response.sendRedirect(this.redirectSuccess);
        }
        catch (JavaMailerException jme) {
            LOG.warn("Issue encountered when sending email", (Throwable)jme);
            PrintWriter out = response.getWriter();
            StreamUtils.streamToStream((Reader)new StringReader(jme.getMessage()), (Writer)out);
            out.close();
        }
    }
}

