/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opennms.web.api.Util;

public class HttpsRewriteFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpResponse = (HttpServletResponse)servletResponse;
        String requestURL = httpRequest.getRequestURL().toString();
        Object calculatedURL = Util.calculateUrlBase((HttpServletRequest)httpRequest);
        if (((String)calculatedURL).startsWith("https:") && requestURL.startsWith("http:")) {
            if (httpRequest.getServletPath().equals("/")) {
                calculatedURL = (String)calculatedURL + "frontPage.htm";
            }
            httpResponse.setStatus(301);
            httpResponse.setHeader("Connection", "close");
            httpResponse.setHeader("Location", (String)calculatedURL);
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }
}

