/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.sql.DataSource;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.db.install.SimpleDataSource;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.opennmsDataSources.DataSourceConfiguration;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.opennms.upgrade.api.OnmsUpgrade;
import org.opennms.upgrade.api.OnmsUpgradeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOnmsUpgrade
implements OnmsUpgrade {
    private static final String MERIDIAN = "meridian";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractOnmsUpgrade.class);
    public static final String ZIP_EXT = ".zip";
    private Properties mainProperties;
    private Properties rrdProperties;
    private String onmsVersion;
    private String onmsProductDescription = "OpenNMS";
    private String onmsProductName = "opennms";
    private DataSource dataSource;

    public AbstractOnmsUpgrade() throws OnmsUpgradeException {
        this.registerProperties(this.getMainProperties());
        this.registerProperties(this.getRrdProperties());
        this.locateOpenNMSProduct();
    }

    protected void setVersion(String version) {
        this.onmsVersion = version;
    }

    protected void setProductName(String productName) {
        this.onmsProductName = productName;
    }

    protected void setProductDescription(String productDescription) {
        this.onmsProductDescription = productDescription;
    }

    @Override
    public String getId() {
        return this.getClass().getSimpleName();
    }

    protected String getHomeDirectory() {
        return ConfigFileConstants.getHome();
    }

    protected File[] getFiles(File resourceDir, final String ext) {
        return resourceDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(ext);
            }
        });
    }

    protected void registerProperties(Properties properties) {
        if (properties == null) {
            return;
        }
        for (Object o : properties.keySet()) {
            String key = (String)o;
            System.setProperty(key, properties.getProperty(key));
        }
    }

    protected void loadProperties(Properties properties, String fileName) throws OnmsUpgradeException {
        try {
            File propertiesFile = ConfigFileConstants.getConfigFileByName((String)fileName);
            properties.load(new FileInputStream(propertiesFile));
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Can't load " + fileName);
        }
    }

    protected Properties getMainProperties() throws OnmsUpgradeException {
        if (this.mainProperties == null) {
            this.mainProperties = new Properties();
            this.loadProperties(this.mainProperties, "opennms.properties");
        }
        return this.mainProperties;
    }

    protected Properties getRrdProperties() throws OnmsUpgradeException {
        if (this.rrdProperties == null) {
            this.rrdProperties = new Properties();
            this.loadProperties(this.rrdProperties, "rrd-configuration.properties");
        }
        return this.rrdProperties;
    }

    protected boolean isStoreByGroupEnabled() {
        try {
            return Boolean.parseBoolean(this.getMainProperties().getProperty("org.opennms.rrd.storeByGroup", "false"));
        }
        catch (Exception e) {
            return false;
        }
    }

    protected boolean isStoreByForeignSourceEnabled() {
        try {
            return Boolean.parseBoolean(this.getMainProperties().getProperty("org.opennms.rrd.storeByForeignSource", "false"));
        }
        catch (Exception e) {
            return false;
        }
    }

    protected String getRrdStrategy() throws OnmsUpgradeException {
        return this.getRrdProperties().getProperty("org.opennms.rrd.strategyClass", "org.opennms.netmgt.rrd.jrobin.JRobinRrdStrategy");
    }

    protected boolean isRrdToolEnabled() throws OnmsUpgradeException {
        return !this.getRrdStrategy().endsWith("JRobinRrdStrategy");
    }

    protected String getRrdExtension() throws OnmsUpgradeException {
        if (System.getProperty("org.opennms.rrd.fileExtension") != null) {
            return System.getProperty("org.opennms.rrd.fileExtension");
        }
        return this.isRrdToolEnabled() ? ".rrd" : ".jrb";
    }

    protected Connection getDbConnection() throws OnmsUpgradeException {
        this.initializeDatasource();
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new OnmsUpgradeException("Can't obtain a connection to OpenNMS Database because " + e.getMessage(), e);
        }
    }

    protected void initializeDatasource() throws OnmsUpgradeException {
        if (this.dataSource != null) {
            return;
        }
        try {
            File cfgFile = ConfigFileConstants.getFile((int)ConfigFileConstants.OPENNMS_DATASOURCE_CONFIG_FILE_NAME);
            DataSourceConfiguration dsc = (DataSourceConfiguration)JaxbUtils.unmarshal(DataSourceConfiguration.class, (File)cfgFile);
            for (JdbcDataSource jds : dsc.getJdbcDataSourceCollection()) {
                if (!jds.getName().equals("opennms")) continue;
                this.dataSource = new SimpleDataSource(jds);
                DataSourceFactory.setInstance((DataSource)this.dataSource);
            }
            if (this.dataSource == null) {
                throw new OnmsUpgradeException("Can't find theOpenNMS Database settings.");
            }
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Can't connect to OpenNMS Database because " + e.getMessage(), e);
        }
    }

    private void populateFilesList(File dir, List<File> filesListInDir) throws IOException {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isFile()) {
                filesListInDir.add(file);
                continue;
            }
            this.populateFilesList(file, filesListInDir);
        }
    }

    private File zipFiles(File zipFile, File sourceFolder, List<File> filesToCompress) throws OnmsUpgradeException {
        try {
            FileOutputStream fos = new FileOutputStream(zipFile);
            ZipOutputStream zos = new ZipOutputStream(fos);
            for (File file : filesToCompress) {
                int len;
                String filePath = file.getAbsolutePath();
                this.log("  Zipping %s\n", filePath);
                ZipEntry ze = new ZipEntry(filePath.substring(sourceFolder.getAbsolutePath().length() + 1, filePath.length()));
                zos.putNextEntry(ze);
                FileInputStream fis = new FileInputStream(file);
                byte[] buffer = new byte[1024];
                while ((len = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, len);
                }
                zos.closeEntry();
                fis.close();
            }
            zos.flush();
            zos.close();
            fos.close();
            return zipFile;
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Cannot ZIP files because " + e.getMessage(), e);
        }
    }

    protected void zipDir(File zipFile, File sourceFolder) throws OnmsUpgradeException {
        ArrayList<File> filesToCompress = new ArrayList<File>();
        try {
            this.populateFilesList(sourceFolder, filesToCompress);
        }
        catch (IOException e) {
            throw new OnmsUpgradeException("Cannot ZIP files because " + e.getMessage(), e);
        }
        this.zipFiles(zipFile, sourceFolder, filesToCompress);
    }

    protected File zipFile(File sourceFile) throws OnmsUpgradeException {
        return this.zipFiles(new File(sourceFile.getAbsolutePath() + ZIP_EXT), sourceFile.getParentFile(), Collections.singletonList(sourceFile));
    }

    protected void unzipFile(File zipFile, File outputFolder) throws OnmsUpgradeException {
        try {
            if (!outputFolder.exists() && !outputFolder.mkdirs()) {
                LOG.warn("Could not make directory: {}", (Object)outputFolder.getPath());
            }
            byte[] buffer = new byte[1024];
            FileInputStream fis = new FileInputStream(zipFile);
            ZipInputStream zis = new ZipInputStream(fis);
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                int len;
                String fileName = ze.getName();
                File newFile = new File(outputFolder, fileName);
                this.log("  Unzipping to %s\n", newFile.getAbsolutePath());
                new File(newFile.getParent()).mkdirs();
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.close();
                zis.closeEntry();
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            fis.close();
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Cannot UNZIP file because " + e.getMessage(), e);
        }
    }

    protected String getOpennmsVersion() throws OnmsUpgradeException {
        if (this.onmsVersion == null) {
            File versionFile = new File(this.getHomeDirectory(), "jetty-webapps/opennms/WEB-INF/version.properties");
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(versionFile));
            }
            catch (Exception e) {
                throw new OnmsUpgradeException("Can't load " + versionFile);
            }
            String version = properties.getProperty("version.display");
            if (version == null) {
                throw new OnmsUpgradeException("Can't retrive OpenNMS version");
            }
            Pattern versionPattern = Pattern.compile("^(\\d+\\.\\d+\\.\\d+).*?$");
            Matcher m = versionPattern.matcher(version);
            this.onmsVersion = m.matches() ? m.group(1) : version;
        }
        return this.onmsVersion;
    }

    private void locateOpenNMSProduct() {
        try {
            InputStream installerProperties = this.getClass().getResourceAsStream("/installer.properties");
            if (installerProperties != null) {
                Properties props = new Properties();
                props.load(installerProperties);
                installerProperties.close();
                this.onmsProductName = (String)props.get("install.package.name");
                this.onmsProductDescription = (String)props.get("install.package.description");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getOpennmsProductName() {
        return this.onmsProductName;
    }

    public String getOpennmsProductDescription() {
        return this.onmsProductDescription;
    }

    public boolean isMeridian() {
        return this.getOpennmsProductName().equals(MERIDIAN);
    }

    protected boolean isInstalledVersion(VersionOperator op, int mayor, int minor, int release) throws OnmsUpgradeException {
        int[] installedVersion = this.getInstalledVersion();
        int supplied = AbstractOnmsUpgrade.versionToInteger(mayor, minor, release);
        int installed = AbstractOnmsUpgrade.versionToInteger(installedVersion[0], installedVersion[1], installedVersion[2]);
        switch (op) {
            case LT: {
                return installed < supplied;
            }
            case LE: {
                return installed <= supplied;
            }
            case EQ: {
                return installed == supplied;
            }
            case GE: {
                return installed >= supplied;
            }
            case GT: {
                return installed > supplied;
            }
        }
        throw new OnmsUpgradeException("Should never happen.");
    }

    protected boolean isInstalledVersionGreaterOrEqual(int mayor, int minor, int release) throws OnmsUpgradeException {
        return this.isInstalledVersion(VersionOperator.GE, mayor, minor, release);
    }

    protected int[] getInstalledVersion() throws OnmsUpgradeException {
        String version = this.getOpennmsVersion();
        String[] a = version.split("\\.");
        int c_major = this.isMeridian() ? Integer.parseInt(a[0]) + 13 : Integer.parseInt(a[0]);
        int c_minor = this.isMeridian() ? Integer.parseInt(a[1]) + 1 : Integer.parseInt(a[1]);
        int c_release = Integer.parseInt(a[2]);
        return new int[]{c_major, c_minor, c_release};
    }

    protected static int versionToInteger(int mayor, int minor, int release) throws OnmsUpgradeException {
        return mayor * 100 + minor * 10 + release;
    }

    protected void printMainSettings() throws OnmsUpgradeException {
        this.log("OpenNMS Home: %s\n", this.getHomeDirectory());
        this.log("OpenNMS Version: %s\n", this.getOpennmsProductDescription() + " " + this.getOpennmsVersion());
        this.log("Is RRDtool enabled? %s\n", this.isRrdToolEnabled());
        this.log("Is storeByGroup enabled? %s\n", this.isStoreByGroupEnabled());
        this.log("Is storeByForeignSource enabled? %s\n", this.isStoreByForeignSourceEnabled());
        this.log("RRD Extension: %s\n", this.getRrdExtension());
        this.log("RRD Strategy: %s\n", this.getRrdStrategy());
    }

    protected void printFullSettings() throws OnmsUpgradeException {
        this.printMainSettings();
        this.printProperties("Main Properties", this.getMainProperties());
        this.printProperties("RRD Properties", this.getRrdProperties());
    }

    private void printProperties(String title, Properties properties) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Object k : properties.keySet()) {
            keys.add((String)k);
        }
        Collections.sort(keys);
        this.log("%s\n", title);
        for (String key : keys) {
            this.log("  %s = %s\n", key, properties.getProperty(key));
        }
    }

    protected void log(String msgFormat, Object ... args) {
        System.out.printf("  " + msgFormat, args);
    }

    public static enum VersionOperator {
        LT,
        LE,
        EQ,
        GE,
        GT;

    }
}

