/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.sdp.impl;

import io.pkts.sdp.RTPInfo;
import javax.sdp.Connection;
import javax.sdp.MediaDescription;
import javax.sdp.SdpParseException;

public final class RTPInfoImpl
implements RTPInfo {
    private final Connection connection;
    private final MediaDescription mediaDescription;

    public RTPInfoImpl(Connection connection, MediaDescription mediaDescription) {
        this.connection = mediaDescription.getConnection() != null ? mediaDescription.getConnection() : connection;
        this.mediaDescription = mediaDescription;
    }

    public String toString() {
        return this.connection + this.mediaDescription.toString();
    }

    @Override
    public String getAddress() {
        try {
            if (this.connection != null) {
                return this.connection.getAddress();
            }
            return this.mediaDescription.getConnection().getAddress();
        }
        catch (SdpParseException e) {
            throw new RuntimeException("TODO: real exception pls", e);
        }
    }

    @Override
    public byte[] getRawAddress() {
        String address = this.getAddress();
        String[] parts = address.split("\\.");
        if (parts.length == 4) {
            try {
                byte[] raw = new byte[]{(byte)Integer.parseInt(parts[0]), (byte)Integer.parseInt(parts[1]), (byte)Integer.parseInt(parts[2]), (byte)Integer.parseInt(parts[3])};
                return raw;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Address is not a raw IPv4 address");
            }
        }
        throw new IllegalArgumentException("Address is not a raw IPv4 address");
    }

    @Override
    public int getMediaPort() {
        try {
            return this.mediaDescription.getMedia().getMediaPort();
        }
        catch (SdpParseException e) {
            throw new RuntimeException("TODO: real exception pls", e);
        }
    }
}

