/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.deviceconfig.monitor.adaptor;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.time.Period;
import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.opennms.core.utils.StringUtils;
import org.opennms.features.deviceconfig.persistence.api.DeviceConfigDao;
import org.opennms.features.deviceconfig.persistence.api.DeviceConfigStatus;
import org.opennms.features.deviceconfig.service.DeviceConfigUtil;
import org.opennms.features.usageanalytics.api.UsageAnalyticDao;
import org.opennms.features.usageanalytics.api.UsageAnalyticMetricName;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.events.api.model.IParm;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.poller.DeviceConfig;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.ServiceMonitorAdaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@EventListener(name="OpenNMS.DeviceConfig", logPrefix="poller")
public class DeviceConfigMonitorAdaptor
implements ServiceMonitorAdaptor {
    private static final Logger LOG = LoggerFactory.getLogger(DeviceConfigMonitorAdaptor.class);
    private static final String DEVICE_CONFIG_SVC_NAME = "DeviceConfig";
    private static final Period DEFAULT_RETENTION_PERIOD = Period.of(1, 0, 0);
    @Autowired
    private DeviceConfigDao deviceConfigDao;
    @Autowired
    private IpInterfaceDao ipInterfaceDao;
    @Autowired
    private EventForwarder eventForwarder;
    @Autowired
    private UsageAnalyticDao usageAnalyticDao;
    @Autowired
    private NodeDao nodeDao;
    @Autowired
    private SessionUtils sessionUtils;

    public PollStatus handlePollResult(MonitoredService svc, Map<String, Object> parameters, PollStatus status) {
        DeviceConfig deviceConfig = status.getDeviceConfig();
        if (deviceConfig == null && !svc.getSvcName().startsWith(DEVICE_CONFIG_SVC_NAME)) {
            return status;
        }
        OnmsIpInterface ipInterface = this.ipInterfaceDao.findByNodeIdAndIpAddress(Integer.valueOf(svc.getNodeId()), svc.getIpAddr());
        boolean triggered = Boolean.parseBoolean(DeviceConfigMonitorAdaptor.getKeyedString(parameters, "dcbTriggeredPoll", "false"));
        String controlProtocol = triggered ? "REST" : "cron";
        String dataProtocol = DeviceConfigMonitorAdaptor.getKeyedString(parameters, "backupDataProtocol", "TFTP");
        long timestamp = Long.parseLong(DeviceConfigMonitorAdaptor.getKeyedString(parameters, "backupStartTime", "0"));
        Optional latestConfig = this.deviceConfigDao.getLatestConfigForInterface(ipInterface, svc.getSvcName());
        String encoding = DeviceConfigMonitorAdaptor.getKeyedString(parameters, "encoding", Charset.defaultCharset().name());
        String configType = DeviceConfigMonitorAdaptor.getKeyedString(parameters, "config-type", "default");
        if (deviceConfig == null && latestConfig.isEmpty()) {
            this.deviceConfigDao.createEmptyDeviceConfig(ipInterface, svc.getSvcName(), configType);
            return status;
        }
        if (deviceConfig == null) {
            DeviceConfigStatus deviceStatus = ((org.opennms.features.deviceconfig.persistence.api.DeviceConfig)latestConfig.get()).getStatus();
            if (deviceStatus.equals((Object)DeviceConfigStatus.FAILED)) {
                String failureReason = ((org.opennms.features.deviceconfig.persistence.api.DeviceConfig)latestConfig.get()).getFailureReason();
                return PollStatus.down((String)failureReason);
            }
            if (deviceStatus.equals((Object)DeviceConfigStatus.SUCCESS)) {
                return PollStatus.up();
            }
            return status;
        }
        this.sendEvent(ipInterface, svc.getSvcName(), "uei.opennms.org/deviceconfig/configBackupStarted", svc.getNodeId(), timestamp, Map.of("backupControlProtocol", controlProtocol, "backupDataProtocol", dataProtocol));
        if (deviceConfig.getContent() == null) {
            this.deviceConfigDao.updateDeviceConfigFailure(ipInterface, svc.getSvcName(), configType, encoding, status.getReason());
            this.sendEvent(ipInterface, svc.getSvcName(), "uei.opennms.org/deviceconfig/configBackupFailed", svc.getNodeId(), Map.of("eventReason", status.getReason()));
        } else {
            byte[] content = deviceConfig.getContent();
            if (DeviceConfigUtil.isGzipFile((String)deviceConfig.getFilename())) {
                try {
                    content = DeviceConfigUtil.decompressGzipToBytes((byte[])content);
                }
                catch (IOException e) {
                    LOG.warn("Failed to decompress content from file {}", (Object)deviceConfig.getFilename());
                }
            }
            Optional updatedId = this.deviceConfigDao.updateDeviceConfigContent(ipInterface, svc.getSvcName(), configType, encoding, content, deviceConfig.getFilename());
            this.sendEvent(ipInterface, svc.getSvcName(), "uei.opennms.org/deviceconfig/configBackupSucceeded", svc.getNodeId(), Map.of());
            if (latestConfig.isPresent()) {
                this.cleanupStaleConfigs(parameters, ipInterface, svc.getSvcName(), updatedId);
            }
        }
        if (status.isUp()) {
            this.usageAnalyticDao.incrementCounterByMetricName(UsageAnalyticMetricName.DCB_SUCCEED.toString());
        } else {
            this.usageAnalyticDao.incrementCounterByMetricName(UsageAnalyticMetricName.DCB_FAILED.toString());
        }
        return status;
    }

    @EventHandler(uei="uei.opennms.org/nodes/interfaceDeleted")
    public void handleInterfaceDeletedEvent(IEvent event) {
        LOG.debug("Received event: {}", (Object)event.getUei());
        Long nodeId = event.getNodeid();
        Integer ipInterfaceId = -1;
        if (nodeId == null) {
            LOG.error("uei.opennms.org/nodes/interfaceDeleted: Event with no node ID: " + event);
            return;
        }
        InetAddress ipAddress = event.getInterfaceAddress();
        if (ipAddress == null) {
            LOG.error("uei.opennms.org/nodes/interfaceDeleted: Event with no Interface Address : " + event);
            return;
        }
        IParm iParm = event.getParm("ipInterfaceID");
        if (iParm.isValid()) {
            String value = iParm.getValue().getContent();
            ipInterfaceId = StringUtils.parseInt((String)value, (Integer)ipInterfaceId);
        }
        if (ipInterfaceId < 0) {
            LOG.error("uei.opennms.org/nodes/interfaceDeleted: Event with no Interface Id : " + event);
            return;
        }
        Integer interfaceId = ipInterfaceId;
        this.sessionUtils.withTransaction(() -> {
            List deviceConfigList = this.deviceConfigDao.getAllDeviceConfigsWithAnInterfaceId(interfaceId);
            if (!deviceConfigList.isEmpty()) {
                deviceConfigList.forEach(dc -> this.deviceConfigDao.delete(dc));
                LOG.info("Deleted all device configs on Interface {}", (Object)interfaceId);
            }
            return null;
        });
    }

    private void cleanupStaleConfigs(Map<String, Object> parameters, OnmsIpInterface ipInterface, String serviceName, Optional<Long> excludedId) {
        Date currentDate = new Date();
        String retentionPeriodPattern = DeviceConfigMonitorAdaptor.getKeyedString(parameters, "retention-period", null);
        Period retentionPeriod = DeviceConfigMonitorAdaptor.getRetentionPeriodOrDefault(retentionPeriodPattern);
        Date retentionDate = Date.from(currentDate.toInstant().atZone(ZoneId.systemDefault()).minus(retentionPeriod).toInstant());
        List staleConfigs = this.deviceConfigDao.findStaleConfigs(ipInterface, serviceName, retentionDate, excludedId);
        if (!staleConfigs.isEmpty()) {
            LOG.debug("DCB: Found {} stale device config records to delete", (Object)staleConfigs.size());
            staleConfigs.stream().map(org.opennms.features.deviceconfig.persistence.api.DeviceConfig::getId).forEach(arg_0 -> ((DeviceConfigDao)this.deviceConfigDao).delete(arg_0));
        }
    }

    private static Period getRetentionPeriodOrDefault(String pattern) {
        if (!Strings.isNullOrEmpty((String)pattern)) {
            try {
                return Period.parse(pattern);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return DEFAULT_RETENTION_PERIOD;
    }

    public void setDeviceConfigDao(DeviceConfigDao deviceConfigDao) {
        this.deviceConfigDao = deviceConfigDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao ipInterfaceDao) {
        this.ipInterfaceDao = ipInterfaceDao;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.eventForwarder = eventForwarder;
    }

    private void sendEvent(OnmsIpInterface ipInterface, String serviceName, String uei, int nodeId, Map<String, String> params) {
        this.sendEvent(ipInterface, serviceName, uei, nodeId, 0L, params);
    }

    private void sendEvent(OnmsIpInterface ipInterface, String serviceName, String uei, int nodeId, long timestamp, Map<String, String> params) {
        EventBuilder bldr = new EventBuilder(uei, "poller");
        bldr.setIpInterface(ipInterface);
        bldr.setService(serviceName);
        bldr.setNodeid((long)nodeId);
        if (timestamp > 0L) {
            bldr.setTime(new Date(timestamp));
        }
        params.forEach((arg_0, arg_1) -> ((EventBuilder)bldr).addParam(arg_0, arg_1));
        this.eventForwarder.sendNowSync(bldr.getEvent());
    }

    private static String getKeyedString(Map<String, Object> parameterMap, String key, String defaultValue) {
        Object value;
        String ret = defaultValue;
        if (key != null && (value = parameterMap.get(key)) != null) {
            ret = value instanceof String ? (String)value : value.toString();
        }
        return ret;
    }
}

