/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.distributed.kvstore.api;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.opennms.features.distributed.kvstore.api.BlobStore;

public final class SerializingBlobStore<V> {
    private final BlobStore blobStore;
    private final Serializer<V> serializer;
    private final Deserializer<V> deserializer;

    public SerializingBlobStore(BlobStore blobStore, Serializer<V> serializer, Deserializer<V> deserializer) {
        this.blobStore = Objects.requireNonNull(blobStore);
        this.serializer = Objects.requireNonNull(serializer);
        this.deserializer = Objects.requireNonNull(deserializer);
    }

    public static <U> SerializingBlobStore<U> ofType(BlobStore blobStore, Serializer<U> serializer, Deserializer<U> deserializer) {
        return new SerializingBlobStore<U>(blobStore, serializer, deserializer);
    }

    public long put(String key, V value, String context) {
        return this.blobStore.put(key, this.serializer.serialize(value), context);
    }

    public long put(String key, V value, String context, Integer ttlInSeconds) {
        return this.blobStore.put(key, this.serializer.serialize(value), context, ttlInSeconds);
    }

    public Optional<V> get(String key, String context) {
        return this.blobStore.get(key, context).map(this.deserializer::deserialize);
    }

    public Optional<Optional<V>> getIfStale(String key, String context, long timestamp) {
        return this.blobStore.getIfStale(key, context, timestamp).map(o -> o.map(this.deserializer::deserialize));
    }

    public CompletableFuture<Long> putAsync(String key, V value, String context) {
        return this.blobStore.putAsync(key, this.serializer.serialize(value), context);
    }

    public CompletableFuture<Long> putAsync(String key, V value, String context, Integer ttlInSeconds) {
        return this.blobStore.putAsync(key, this.serializer.serialize(value), context, ttlInSeconds);
    }

    public CompletableFuture<Optional<V>> getAsync(String key, String context) {
        return this.blobStore.getAsync(key, context).thenApply(o -> o.map(this.deserializer::deserialize));
    }

    public CompletableFuture<Optional<Optional<V>>> getIfStaleAsync(String key, String context, long timestamp) {
        return this.blobStore.getIfStaleAsync(key, context, timestamp).thenApply(o -> o.map(ov -> ov.map(this.deserializer::deserialize)));
    }

    public Map<String, V> enumerateContext(String context) {
        return this.deserializeMap(this.blobStore.enumerateContext(context));
    }

    public CompletableFuture<Map<String, V>> enumerateContextAsync(String context) {
        return this.blobStore.enumerateContextAsync(context).thenApply(this::deserializeMap);
    }

    private Map<String, V> deserializeMap(Map<String, byte[]> inputMap) {
        return Collections.unmodifiableMap(inputMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.deserializer.deserialize((byte[])e.getValue()))));
    }

    @FunctionalInterface
    public static interface Serializer<V> {
        public byte[] serialize(V var1);
    }

    @FunctionalInterface
    public static interface Deserializer<V> {
        public V deserialize(byte[] var1);
    }
}

