/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.datachoices.web.internal;

import com.google.common.collect.Maps;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import org.opennms.features.datachoices.internal.StateManager;
import org.opennms.web.api.HtmlInjector;

public class ModalInjector
implements HtmlInjector {
    public static final String CONSENT_TEXT = "I agree to receive email communications from OpenNMS";
    public static final String LEGAL_CONSENT_COMMUNICATION_TEXT = "If you consent to us contacting you, please opt in below. We will maintain your data until you request us to delete it from our systems. You may opt out of receiving communications from us at any time.";
    private StateManager m_stateManager;

    public String inject(HttpServletRequest request) throws TemplateException, IOException {
        String usageStatisticsSharingHtml = this.getUsageStatisticsSharingModalHtml(request);
        String productUpdateEnrollmentHtml = this.getProductUpdateEnrollmentModalHtml(request);
        List items = Stream.of(usageStatisticsSharingHtml, productUpdateEnrollmentHtml).filter(Objects::nonNull).collect(Collectors.toList());
        return items.isEmpty() ? null : String.join((CharSequence)"\n", items);
    }

    protected String getUsageStatisticsSharingModalHtml(HttpServletRequest request) throws TemplateException, IOException {
        boolean hideNotice;
        boolean noticeAcked = this.m_stateManager.isInitialNoticeAcknowledged() != null && this.m_stateManager.isInitialNoticeAcknowledged() != false;
        boolean optedOut = this.m_stateManager.isEnabled() != null && this.m_stateManager.isEnabled() == false;
        boolean bl = hideNotice = noticeAcked || optedOut;
        if (!hideNotice && ModalInjector.isPage("/opennms/index.jsp", request) && ModalInjector.isUserInAdminRole(request)) {
            HashMap data = Maps.newHashMap();
            data.put("showOnLoad", true);
            return ModalInjector.generateModalHtml("modal.ftl.html", data);
        }
        return null;
    }

    protected String getProductUpdateEnrollmentModalHtml(HttpServletRequest request) throws TemplateException, IOException {
        if (Stream.of("opennms.productUpdateEnrollment.show", "opennms.userDataCollection.show").map(key -> System.getProperty(key, "true")).anyMatch(key -> key != null && key.equalsIgnoreCase("false"))) {
            return null;
        }
        boolean noticeSeen = this.m_stateManager.isProductUpdateEnrollmentNoticeAcknowledged();
        if (!noticeSeen && ModalInjector.isPage("/opennms/index.jsp", request) && ModalInjector.isUserInAdminOrRestRole(request)) {
            HashMap data = Maps.newHashMap();
            data.put("consentText", CONSENT_TEXT);
            data.put("legalConsentCommunication", LEGAL_CONSENT_COMMUNICATION_TEXT);
            return ModalInjector.generateModalHtml("product-update-enrollment.ftl.html", data);
        }
        return null;
    }

    protected static String generateModalHtml(String templateName, Map<String, Object> data) throws IOException, TemplateException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_21);
        ClassTemplateLoader ctl = new ClassTemplateLoader(ModalInjector.class, "/web");
        cfg.setTemplateLoader((TemplateLoader)ctl);
        Template template = cfg.getTemplate(templateName);
        StringWriter out = new StringWriter();
        template.process(data, (Writer)out);
        ((Writer)out).flush();
        return ((Object)out).toString();
    }

    protected static boolean isPage(String endOfUri, HttpServletRequest request) {
        String uri = request.getRequestURI();
        if (uri == null) {
            return false;
        }
        return uri.endsWith(endOfUri);
    }

    protected static boolean isUserInAdminRole(HttpServletRequest request) {
        return request.isUserInRole("ROLE_ADMIN");
    }

    protected static boolean isUserInAdminOrRestRole(HttpServletRequest request) {
        return request.isUserInRole("ROLE_ADMIN") || request.isUserInRole("ROLE_REST");
    }

    public void setStateManager(StateManager stateManager) {
        this.m_stateManager = stateManager;
    }
}

