/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.reporting.repository.remote;

import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import org.apache.cxf.common.util.Base64Utility;
import org.opennms.core.mate.api.Interpolator;
import org.opennms.core.mate.api.Scope;
import org.opennms.core.mate.api.SecureCredentialsVaultScope;
import org.opennms.core.spring.BeanUtils;
import org.opennms.features.reporting.model.basicreport.BasicReportDefinition;
import org.opennms.features.reporting.model.jasperreport.SimpleJasperReportDefinition;
import org.opennms.features.reporting.model.remoterepository.RemoteRepositoryDefinition;
import org.opennms.features.reporting.repository.ReportRepository;
import org.opennms.features.reporting.sdo.RemoteReportSDO;
import org.opennms.features.scv.api.SecureCredentialsVault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRemoteRepository
implements ReportRepository {
    private Logger logger = LoggerFactory.getLogger(DefaultRemoteRepository.class);
    private RemoteRepositoryDefinition m_remoteRepositoryDefintion;
    private String m_jasperReportsVersion;
    final String m_authorizationHeader;

    public DefaultRemoteRepository(RemoteRepositoryDefinition remoteRepositoryDefinition, String jasperReportsVersion) {
        this(remoteRepositoryDefinition, jasperReportsVersion, (SecureCredentialsVault)BeanUtils.getBean((String)"jceksScvContext", (String)"jceksSecureCredentialsVault", SecureCredentialsVault.class));
    }

    public DefaultRemoteRepository(RemoteRepositoryDefinition remoteRepositoryDefinition, String jasperReportsVersion, SecureCredentialsVault secureCredentialsVault) {
        this.m_remoteRepositoryDefintion = remoteRepositoryDefinition;
        this.m_jasperReportsVersion = jasperReportsVersion;
        SecureCredentialsVaultScope scope = new SecureCredentialsVaultScope(secureCredentialsVault);
        String loginUser = Interpolator.interpolate((String)this.m_remoteRepositoryDefintion.getLoginUser(), (Scope)scope).output;
        String loginRepoPassword = Interpolator.interpolate((String)this.m_remoteRepositoryDefintion.getLoginRepoPassword(), (Scope)scope).output;
        this.m_authorizationHeader = "Basic " + Base64Utility.encode((byte[])(loginUser + ":" + loginRepoPassword).getBytes());
    }

    @Override
    public List<BasicReportDefinition> getReports() {
        List<BasicReportDefinition> resultReports = new ArrayList<BasicReportDefinition>();
        if (this.isConfigOk().booleanValue()) {
            WebTarget target = this.getTarget(this.m_remoteRepositoryDefintion.getURI() + "reports/" + this.m_jasperReportsVersion);
            List<RemoteReportSDO> webCallResult = new ArrayList();
            try {
                webCallResult = (List)this.getBuilder(target).get((GenericType)new GenericType<List<RemoteReportSDO>>(){});
            }
            catch (Exception e) {
                this.logger.error("Error requesting report template from repository. Error message: '{}' Uri was: '{}'", (Object)e.getMessage(), (Object)target.getUri());
                e.printStackTrace();
            }
            this.logger.debug("getReports got '{}' RemoteReportSDOs from uri '{}'", (Object)webCallResult.size(), (Object)target.getUri());
            resultReports = this.mapSDOListToBasicReportList(webCallResult);
        }
        return resultReports;
    }

    @Override
    public List<BasicReportDefinition> getOnlineReports() {
        List<BasicReportDefinition> resultReports = new ArrayList<BasicReportDefinition>();
        List<RemoteReportSDO> webCallResult = new ArrayList();
        if (this.isConfigOk().booleanValue()) {
            WebTarget target = this.getTarget(this.m_remoteRepositoryDefintion.getURI() + "onlineReports/" + this.m_jasperReportsVersion);
            try {
                webCallResult = (List)this.getBuilder(target).get((GenericType)new GenericType<List<RemoteReportSDO>>(){});
            }
            catch (Exception e) {
                this.logger.error("Error requesting online reports. Error message: '{}' URI was: '{}'", (Object)e.getMessage(), (Object)target.getUri());
                e.printStackTrace();
            }
            this.logger.debug("getOnlineReports got '{}' RemoteReportSDOs from uri '{}'", (Object)webCallResult.size(), (Object)target.getUri());
            resultReports = this.mapSDOListToBasicReportList(webCallResult);
        }
        return resultReports;
    }

    @Override
    public String getReportService(String reportId) {
        reportId = reportId.substring(reportId.indexOf(95) + 1);
        String result = "";
        if (this.isConfigOk().booleanValue()) {
            WebTarget target = this.getTarget(this.m_remoteRepositoryDefintion.getURI() + "reportService/" + reportId);
            try {
                result = (String)this.getBuilder(target).get(String.class);
            }
            catch (Exception e) {
                this.logger.error("Error requesting report service by report id. Error message: '{}' URI was: '{}'", (Object)e.getMessage(), (Object)target.getUri());
                e.printStackTrace();
            }
            this.logger.debug("getReportService for id / result: '{}' URI was: '{}' ", (Object)(reportId + " / " + result), (Object)target.getUri());
        }
        return result;
    }

    @Override
    public String getDisplayName(String reportId) {
        reportId = reportId.substring(reportId.indexOf(95) + 1);
        String result = "";
        if (this.isConfigOk().booleanValue()) {
            WebTarget target = this.getTarget(this.m_remoteRepositoryDefintion.getURI() + "displayName/" + reportId);
            try {
                result = (String)this.getBuilder(target).get(String.class);
            }
            catch (Exception e) {
                this.logger.error("Error requesting display name by report id. Error message: '{}' URI was: '{}'", (Object)e.getMessage(), (Object)target.getUri());
                e.printStackTrace();
            }
            this.logger.debug("getDisplayName for id / result: '{}' URI was: '{}' ", (Object)(reportId + " / " + result), (Object)target.getUri());
        }
        return result;
    }

    @Override
    public String getEngine(String reportId) {
        reportId = reportId.substring(reportId.indexOf(95) + 1);
        String result = "";
        if (this.isConfigOk().booleanValue()) {
            WebTarget target = this.getTarget(this.m_remoteRepositoryDefintion.getURI() + "engine/" + reportId);
            try {
                result = (String)this.getBuilder(target).get(String.class);
            }
            catch (Exception e) {
                this.logger.error("Error requesting engine by id. Error message: '{}' URI was: '{}'", (Object)e.getMessage(), (Object)target.getUri());
                e.printStackTrace();
            }
            this.logger.debug("getEngine for id / result: '{}' URI was: '{}' ", (Object)(reportId + " / " + result), (Object)target.getUri());
        }
        return result;
    }

    @Override
    public InputStream getTemplateStream(String reportId) {
        reportId = reportId.substring(reportId.indexOf(95) + 1);
        InputStream templateStreamResult = null;
        if (this.isConfigOk().booleanValue()) {
            WebTarget target = this.getTarget(this.m_remoteRepositoryDefintion.getURI() + "templateStream/" + reportId);
            try {
                templateStreamResult = (InputStream)this.getBuilder(target).get(InputStream.class);
            }
            catch (Exception e) {
                this.logger.error("Error requesting template stream by id. Error message: '{}' URI was: '{}'", (Object)e.getMessage(), (Object)target.getUri());
                e.printStackTrace();
            }
            this.logger.debug("getTemplateStream for id / inputstream: '{}' URI was: '{}' ", (Object)(reportId + " / " + templateStreamResult), (Object)target.getUri());
        }
        return templateStreamResult;
    }

    @Override
    public String getRepositoryId() {
        this.logger.debug("getRepositoryId was called: '{}'", (Object)this.m_remoteRepositoryDefintion.getRepositoryId());
        return this.m_remoteRepositoryDefintion.getRepositoryId();
    }

    @Override
    public String getRepositoryName() {
        this.logger.debug("getRepositoryName was called: '{}'", (Object)this.m_remoteRepositoryDefintion.getRepositoryName());
        return this.m_remoteRepositoryDefintion.getRepositoryName();
    }

    @Override
    public String getRepositoryDescription() {
        this.logger.debug("getRepositoryDescription was called: '{}'", (Object)this.m_remoteRepositoryDefintion.getRepositoryDescription());
        return this.m_remoteRepositoryDefintion.getRepositoryDescription();
    }

    @Override
    public String getManagementUrl() {
        this.logger.debug("getRepositoryDescription was called: '{}'", (Object)this.m_remoteRepositoryDefintion.getRepositoryDescription());
        return this.m_remoteRepositoryDefintion.getRepositoryManagementURL();
    }

    private Boolean isConfigOk() {
        if (this.m_remoteRepositoryDefintion != null) {
            if (!this.m_remoteRepositoryDefintion.isRepositoryActive().booleanValue()) {
                this.logger.debug("RemoteRepository '{}' is NOT activated.", (Object)this.m_remoteRepositoryDefintion.getRepositoryName());
                return false;
            }
        } else {
            this.logger.debug("Problem by RemoteRepository Config Access. RemoteRepository can't be used.");
            return false;
        }
        return true;
    }

    private List<BasicReportDefinition> mapSDOListToBasicReportList(List<RemoteReportSDO> remoteReportSDOList) {
        ArrayList<BasicReportDefinition> resultList = new ArrayList<BasicReportDefinition>();
        for (RemoteReportSDO report : remoteReportSDOList) {
            SimpleJasperReportDefinition result = new SimpleJasperReportDefinition();
            try {
                org.apache.commons.beanutils.BeanUtils.copyProperties((Object)result, (Object)report);
                result.setId(this.m_remoteRepositoryDefintion.getRepositoryId() + "_" + result.getId());
            }
            catch (IllegalAccessException e) {
                this.logger.debug("SDO to BasicReport mapping IllegalAssessException while copyProperties from '{}' to '{}' with exception.", (Object)report, (Object)result);
                this.logger.error("SDO to BasicReport mapping IllegalAssessException while copyProperties '{}' RepositoryURI: '{}'", (Object)e, (Object)this.m_remoteRepositoryDefintion.getURI());
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                this.logger.debug("SDO to BasicReport mapping InvocationTargetException while copyProperties from '{}' to '{}' with exception.", (Object)report, (Object)result);
                this.logger.error("SDO to BasicReport mapping InvocationTargetException while copyProperties '{}' RepositoryURI: '{}'", (Object)e, (Object)this.m_remoteRepositoryDefintion.getURI());
                e.printStackTrace();
            }
            this.logger.debug("SDO to BasicReport mapping got: '{}'", (Object)report.toString());
            resultList.add((BasicReportDefinition)result);
        }
        this.logger.debug("SDO to BasicReport mapping returns resultList: '{}'", (Object)((Object)resultList).toString());
        return resultList;
    }

    @Override
    public void loadConfiguration() {
        this.logger.debug("reloading for configuration was called. No reoad for remote repository possible.");
    }

    private WebTarget getTarget(String url) {
        Client client = ClientBuilder.newClient();
        return client.target(url);
    }

    private Invocation.Builder getBuilder(WebTarget target) {
        return target.request().header("Authorization", (Object)this.m_authorizationHeader);
    }
}

