/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jest.client;

import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreakerRegistry;
import java.time.Duration;

public class CircuitBreakerProvider {
    private Float failureRateThreshold = null;
    private Long waitDurationInOpenStateInMills = null;
    private Integer ringBufferSizeInHalfOpenState = null;
    private Integer ringBufferSizeInClosedState = null;
    private Class<? extends Throwable>[] recordExceptions = null;
    private Class<? extends Throwable> ignoreExceptions = null;

    public CircuitBreaker getCircuitBreaker(String name) {
        CircuitBreakerConfig.Builder builder = CircuitBreakerConfig.custom();
        if (this.failureRateThreshold != null) {
            builder.failureRateThreshold(this.failureRateThreshold.floatValue());
        }
        if (this.waitDurationInOpenStateInMills != null) {
            builder.waitDurationInOpenState(Duration.ofMillis(this.waitDurationInOpenStateInMills));
        }
        if (this.ringBufferSizeInHalfOpenState != null) {
            builder.ringBufferSizeInHalfOpenState(this.ringBufferSizeInHalfOpenState.intValue());
        }
        if (this.ringBufferSizeInClosedState != null) {
            builder.ringBufferSizeInClosedState(this.ringBufferSizeInClosedState.intValue());
        }
        if (this.recordExceptions != null) {
            builder.recordExceptions((Class[])this.recordExceptions);
        }
        if (this.ignoreExceptions != null) {
            builder.ignoreExceptions(new Class[]{this.ignoreExceptions});
        }
        return CircuitBreakerRegistry.of((CircuitBreakerConfig)builder.build()).circuitBreaker(name);
    }

    public void setFailureRateThreshold(Float failureRateThreshold) {
        this.failureRateThreshold = failureRateThreshold;
    }

    public void setWaitDurationInOpenStateInMills(Long waitDurationInOpenState) {
        this.waitDurationInOpenStateInMills = waitDurationInOpenState;
    }

    public void setRingBufferSizeInHalfOpenState(Integer ringBufferSizeInHalfOpenState) {
        this.ringBufferSizeInHalfOpenState = ringBufferSizeInHalfOpenState;
    }

    public void setRingBufferSizeInClosedState(Integer ringBufferSizeInClosedState) {
        this.ringBufferSizeInClosedState = ringBufferSizeInClosedState;
    }

    public void setRecordExceptions(Class<? extends Throwable>[] recordExceptions) {
        this.recordExceptions = recordExceptions;
    }

    public void setIgnoreExceptions(Class<? extends Throwable> ignoreExceptions) {
        this.ignoreExceptions = ignoreExceptions;
    }
}

