/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.Protocol;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElementDatabase;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Semantics;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.InformationElementProvider;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.xml.Element;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.xml.IpfixElements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InformationElementXmlProvider
implements InformationElementDatabase.Provider {
    private static final Logger LOG = LoggerFactory.getLogger(InformationElementXmlProvider.class);

    private Set<File> getFiles() throws IOException {
        Path ipfixDotD = Paths.get(System.getProperty("karaf.etc"), new String[0]).resolve("ipfix.d");
        try (Stream<Path> stream = Files.list(ipfixDotD);){
            Set<File> set = stream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).filter(path -> path.getFileName().toString().endsWith(".xml")).map(Path::toFile).collect(Collectors.toSet());
            return set;
        }
    }

    @Override
    public void load(InformationElementDatabase.Adder adder) {
        Set<File> files;
        try {
            files = this.getFiles();
        }
        catch (IOException e) {
            LOG.error("Error reading files in directory etc/ipfix.d", (Throwable)e);
            return;
        }
        for (File file : files) {
            IpfixElements ipfixElements;
            try {
                ipfixElements = (IpfixElements)JAXB.unmarshal((File)file, IpfixElements.class);
            }
            catch (DataBindingException e) {
                LOG.error("Cannot load file {}", (Object)file.getAbsolutePath(), (Object)e);
                continue;
            }
            LOG.debug("Processing file {}, {} entries", (Object)file.getAbsolutePath(), (Object)ipfixElements.getElements().size());
            long vendor = ipfixElements.getScope().getPen();
            for (Element element : ipfixElements.getElements()) {
                int id = element.getId();
                String name = element.getName();
                InformationElementDatabase.ValueParserFactory valueParserFactory = InformationElementProvider.TYPE_LOOKUP.get(element.getDataType());
                adder.add(Protocol.IPFIX, Optional.of(vendor), id, valueParserFactory, name, Optional.of(Semantics.DEFAULT));
            }
        }
    }
}

