/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.shell;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.ResourceId;
import org.opennms.netmgt.model.RrdGraphAttribute;

@Command(scope="opennms", name="show-measurement-resources", description="Displays the resource tree. Optionally filter by node or resource ID.")
@Service
public class ShowResources
implements Action {
    @Reference
    SessionUtils sessionUtils;
    @Reference
    NodeDao nodeDao;
    @Reference
    ResourceDao resourceDao;
    @Option(name="-n", aliases={"--node"}, description="Node ID, or FS:FID")
    String nodeCriteria;
    @Option(name="-r", aliases={"--resource-id"}, description="Resource ID")
    String resourceId;
    @Option(name="-c", aliases={"--no-children"}, description="Don't recurse through child resources")
    boolean dontRecurse = false;

    public Object execute() {
        this.sessionUtils.withReadOnlyTransaction(() -> {
            if (this.nodeCriteria != null) {
                OnmsNode node = this.nodeDao.get(this.nodeCriteria);
                if (node == null) {
                    System.out.printf("No node found for: %s\n", this.nodeCriteria);
                    return null;
                }
                this.displayResourceTree(this.resourceDao.getResourceForNode(node));
            } else if (this.resourceId != null) {
                this.displayResourceTree(this.resourceDao.getResourceById(ResourceId.fromString((String)this.resourceId)));
            } else {
                this.displayResourceTree(this.resourceDao.findTopLevelResources());
            }
            return null;
        });
        return null;
    }

    private void displayResourceTree(OnmsResource resource) {
        this.displayResourceTree(Collections.singletonList(resource));
    }

    private void displayResourceTree(List<OnmsResource> resources) {
        for (OnmsResource resource : resources) {
            ShowResources.displayResource(resource);
            if (this.dontRecurse) continue;
            this.displayResourceTree(resource.getChildResources());
        }
    }

    private static void displayResource(OnmsResource resource) {
        System.out.println();
        System.out.println("ID:         " + resource.getId());
        System.out.println("Name:       " + resource.getName());
        System.out.println("Label:      " + resource.getLabel());
        System.out.println("Type:       " + resource.getResourceType().getLabel());
        System.out.println("Link:       " + resource.getLink());
        OnmsResource parent = resource.getParent();
        if (parent != null) {
            System.out.println("Parent ID:  " + parent.getId());
        }
        System.out.println("Children:");
        if (resource.getChildResources() != null) {
            for (OnmsResource onmsResource : resource.getChildResources()) {
                System.out.println("  " + onmsResource.getId());
            }
        }
        System.out.println("Attributes:");
        System.out.println("  External:");
        for (Map.Entry entry : resource.getExternalValueAttributes().entrySet()) {
            System.out.println("    " + (String)entry.getKey() + " = '" + (String)entry.getValue() + "'");
        }
        System.out.println("  Metrics:");
        for (Map.Entry entry : resource.getRrdGraphAttributes().entrySet()) {
            System.out.println("    " + (String)entry.getKey() + " = '" + ((RrdGraphAttribute)entry.getValue()).getRrdFile() + "'");
        }
        System.out.println("  Strings:");
        for (Map.Entry entry : resource.getStringPropertyAttributes().entrySet()) {
            System.out.println("    " + (String)entry.getKey() + " = '" + (String)entry.getValue() + "'");
        }
    }
}

