/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.topology;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.integration.api.v1.topology.UserDefinedLink;
import org.opennms.integration.api.v1.topology.UserDefinedLinkDao;
import org.opennms.integration.api.v1.topology.immutables.ImmutableUserDefinedLink;
import org.opennms.netmgt.dao.api.SessionUtils;
import org.opennms.netmgt.enlinkd.service.api.UserDefinedLinkTopologyService;

public class UserDefinedLinkDaoImpl
implements UserDefinedLinkDao {
    private final org.opennms.netmgt.enlinkd.persistence.api.UserDefinedLinkDao userDefinedLinkDao;
    private final UserDefinedLinkTopologyService userDefinedLinkTopologyService;
    private final SessionUtils sessionUtils;

    public UserDefinedLinkDaoImpl(org.opennms.netmgt.enlinkd.persistence.api.UserDefinedLinkDao userDefinedLinkDao, UserDefinedLinkTopologyService userDefinedLinkTopologyService, SessionUtils sessionUtils) {
        this.userDefinedLinkDao = Objects.requireNonNull(userDefinedLinkDao);
        this.userDefinedLinkTopologyService = Objects.requireNonNull(userDefinedLinkTopologyService);
        this.sessionUtils = Objects.requireNonNull(sessionUtils);
    }

    public List<UserDefinedLink> getLinks() {
        return (List)this.sessionUtils.withReadOnlyTransaction(() -> this.userDefinedLinkDao.findAll().stream().map(UserDefinedLinkDaoImpl::toApiLink).collect(Collectors.toList()));
    }

    public List<UserDefinedLink> getOutLinks(int nodeIdA) {
        return (List)this.sessionUtils.withReadOnlyTransaction(() -> this.userDefinedLinkDao.getOutLinks(nodeIdA).stream().map(UserDefinedLinkDaoImpl::toApiLink).collect(Collectors.toList()));
    }

    public List<UserDefinedLink> getInLinks(int nodeIdZ) {
        return (List)this.sessionUtils.withReadOnlyTransaction(() -> this.userDefinedLinkDao.getInLinks(nodeIdZ).stream().map(UserDefinedLinkDaoImpl::toApiLink).collect(Collectors.toList()));
    }

    public List<UserDefinedLink> getLinksWithLabel(String label) {
        return (List)this.sessionUtils.withReadOnlyTransaction(() -> this.userDefinedLinkDao.getLinksWithLabel(label).stream().map(UserDefinedLinkDaoImpl::toApiLink).collect(Collectors.toList()));
    }

    public UserDefinedLink saveOrUpdate(UserDefinedLink link) {
        return (UserDefinedLink)this.sessionUtils.withTransaction(() -> {
            org.opennms.netmgt.enlinkd.model.UserDefinedLink modelLink = UserDefinedLinkDaoImpl.toModelLink(link);
            this.userDefinedLinkTopologyService.saveOrUpdate(modelLink);
            return UserDefinedLinkDaoImpl.toApiLink(modelLink);
        });
    }

    public void delete(UserDefinedLink link) {
        this.sessionUtils.withTransaction(() -> {
            this.userDefinedLinkTopologyService.delete(link.getDbId());
            return null;
        });
    }

    public void delete(Collection<UserDefinedLink> links) {
        this.sessionUtils.withTransaction(() -> {
            for (UserDefinedLink link : links) {
                this.userDefinedLinkTopologyService.delete(link.getDbId());
            }
            return null;
        });
    }

    protected static UserDefinedLink toApiLink(org.opennms.netmgt.enlinkd.model.UserDefinedLink modelLink) {
        return ImmutableUserDefinedLink.newBuilder().setDbId(modelLink.getDbId()).setOwner(modelLink.getOwner()).setLinkId(modelLink.getLinkId()).setLinkLabel(modelLink.getLinkLabel()).setNodeIdA(modelLink.getNodeIdA()).setNodeIdZ(modelLink.getNodeIdZ()).setComponentLabelA(modelLink.getComponentLabelA()).setComponentLabelZ(modelLink.getComponentLabelZ()).build();
    }

    protected static org.opennms.netmgt.enlinkd.model.UserDefinedLink toModelLink(UserDefinedLink apiLink) {
        org.opennms.netmgt.enlinkd.model.UserDefinedLink modelLink = new org.opennms.netmgt.enlinkd.model.UserDefinedLink();
        modelLink.setDbId(apiLink.getDbId());
        modelLink.setOwner(apiLink.getOwner());
        modelLink.setLinkId(apiLink.getLinkId());
        modelLink.setLinkLabel(apiLink.getLinkLabel());
        modelLink.setNodeIdA(Integer.valueOf(apiLink.getNodeIdA()));
        modelLink.setNodeIdZ(Integer.valueOf(apiLink.getNodeIdZ()));
        modelLink.setComponentLabelA(apiLink.getComponentLabelA());
        modelLink.setComponentLabelZ(apiLink.getComponentLabelZ());
        return modelLink;
    }
}

