/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import java.net.InetAddress;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import org.jolokia.client.J4pClient;
import org.jolokia.client.J4pClientBuilder;
import org.jolokia.client.exception.J4pConnectException;
import org.jolokia.client.exception.J4pException;
import org.jolokia.client.exception.J4pRemoteException;
import org.jolokia.client.request.J4pExecRequest;
import org.jolokia.client.request.J4pExecResponse;
import org.jolokia.client.request.J4pReadRequest;
import org.jolokia.client.request.J4pReadResponse;
import org.jolokia.client.request.J4pRequest;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.utils.TimeoutTracker;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.support.ParameterSubstitutingMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JolokiaBeanMonitor
extends ParameterSubstitutingMonitor {
    private static final int DEFAULT_PORT = 8080;
    private static final int DEFAULT_RETRY = 0;
    private static final int DEFAULT_TIMEOUT = 3000;
    public static final String PARAMETER_URL = "url";
    public static final String PARAMETER_USERNAME = "auth-username";
    public static final String PARAMETER_PASSWORD = "auth-password";
    public static final String PARAMETER_BANNER = "banner";
    public static final String PARAMETER_PORT = "port";
    public static final String PARAMETER_BEANNAME = "beanname";
    public static final String PARAMETER_ATTRNAME = "attrname";
    public static final String PARAMETER_ATTRPATH = "attrpath";
    public static final String PARAMETER_METHODNAME = "methodname";
    public static final String PARAMETER_METHODINPUT1 = "input1";
    public static final String PARAMETER_METHODINPUT2 = "input2";
    public static final String DEFAULT_URL = "http://${ipaddr}:${port}/jolokia";
    private static final Logger LOGGER = LoggerFactory.getLogger(JolokiaBeanMonitor.class);

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        TimeoutTracker tracker = new TimeoutTracker(parameters, 0, 3000);
        int port = ParameterMap.getKeyedInteger(parameters, (String)PARAMETER_PORT, (int)8080);
        String strURL = JolokiaBeanMonitor.resolveKeyedString(parameters, (String)PARAMETER_URL, (String)DEFAULT_URL);
        String strUser = JolokiaBeanMonitor.resolveKeyedString(parameters, (String)PARAMETER_USERNAME, null);
        String strPasswd = JolokiaBeanMonitor.resolveKeyedString(parameters, (String)PARAMETER_PASSWORD, null);
        String strAttrName = ParameterMap.getKeyedString(parameters, (String)PARAMETER_ATTRNAME, null);
        String strAttrPath = ParameterMap.getKeyedString(parameters, (String)PARAMETER_ATTRPATH, null);
        String strBeanName = ParameterMap.getKeyedString(parameters, (String)PARAMETER_BEANNAME, null);
        String strMethodName = JolokiaBeanMonitor.resolveKeyedString(parameters, (String)PARAMETER_METHODNAME, null);
        String strInput1 = JolokiaBeanMonitor.resolveKeyedString(parameters, (String)PARAMETER_METHODINPUT1, null);
        String strInput2 = JolokiaBeanMonitor.resolveKeyedString(parameters, (String)PARAMETER_METHODINPUT2, null);
        String strBannerMatch = JolokiaBeanMonitor.resolveKeyedString(parameters, (String)PARAMETER_BANNER, null);
        InetAddress ipAddr = svc.getAddress();
        String hostAddress = InetAddressUtils.str((InetAddress)ipAddr);
        LOGGER.debug("poll: address = " + hostAddress + ", port = " + port + ", " + tracker);
        strURL = strURL.replace("${ipaddr}", hostAddress);
        strURL = strURL.replace("${port}", Integer.valueOf(port).toString());
        LOGGER.debug("poll: final URL address = " + strURL);
        PollStatus serviceStatus = PollStatus.unknown((String)"Initialized");
        tracker.reset();
        while (tracker.shouldRetry() && !serviceStatus.isAvailable()) {
            String reason;
            try {
                String response;
                tracker.startAttempt();
                J4pClientBuilder j4pClientBuilder = new J4pClientBuilder();
                j4pClientBuilder.url(strURL).connectionTimeout(tracker.getConnectionTimeout()).socketTimeout(tracker.getSoTimeout());
                if (strUser != null && strPasswd != null) {
                    j4pClientBuilder.user(strUser).password(strPasswd);
                }
                J4pClient j4pClient = j4pClientBuilder.build();
                LOGGER.debug("JolokiaBeanMonitor: connected to URLhost: " + strURL);
                serviceStatus = PollStatus.unresponsive();
                if (strBannerMatch == null || strBannerMatch.length() == 0 || strBannerMatch.equals("*")) {
                    serviceStatus = PollStatus.available((Double)tracker.elapsedTimeInMillis());
                    break;
                }
                if (strAttrName != null) {
                    J4pReadRequest readReq = new J4pReadRequest(strBeanName, new String[]{strAttrName});
                    readReq.setPreferredHttpMethod("POST");
                    if (strAttrPath != null) {
                        readReq.setPath(strAttrPath);
                    }
                    resp = (J4pReadResponse)j4pClient.execute((J4pRequest)readReq);
                    response = resp.getValue().toString();
                } else {
                    J4pExecRequest execReq;
                    if (strInput1 == null && strInput2 == null) {
                        LOGGER.debug("JolokiaBeanMonitor - execute bean: " + strBeanName + " method: " + strMethodName);
                        execReq = new J4pExecRequest(strBeanName, strMethodName, new Object[0]);
                    } else if (strInput1 != null && strInput2 == null) {
                        LOGGER.debug("JolokiaBeanMonitor - execute bean: " + strBeanName + " method: " + strMethodName + " args: " + strInput1);
                        execReq = new J4pExecRequest(strBeanName, strMethodName, new Object[]{strInput1});
                    } else {
                        LOGGER.debug("JolokiaBeanMonitor - execute bean: " + strBeanName + " method: " + strMethodName + " args: " + strInput1 + " " + strInput2);
                        execReq = new J4pExecRequest(strBeanName, strMethodName, new Object[]{strInput1, strInput2});
                    }
                    execReq.setPreferredHttpMethod("POST");
                    resp = (J4pExecResponse)j4pClient.execute((J4pRequest)execReq);
                    response = resp.getValue().toString();
                }
                double responseTime = tracker.elapsedTimeInMillis();
                if (response != null) {
                    LOGGER.debug("poll: banner = " + response);
                    LOGGER.debug("poll: responseTime = " + responseTime + "ms");
                    serviceStatus = strBannerMatch.charAt(0) == '~' ? (!response.matches(strBannerMatch.substring(1)) ? PollStatus.unavailable((String)("Banner does not match Regex '" + strBannerMatch + "'")) : PollStatus.available((Double)responseTime)) : (response.contains(strBannerMatch) ? PollStatus.available((Double)responseTime) : PollStatus.unavailable((String)("Did not find expected Text '" + strBannerMatch + "'")));
                }
            }
            catch (J4pConnectException e) {
                reason = "Connection exception for address: " + ipAddr + ":" + port + " " + e.getMessage();
                LOGGER.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable((String)reason);
                break;
            }
            catch (J4pRemoteException e) {
                reason = "Remote exception from J4pRemote: " + e.getMessage();
                LOGGER.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable((String)reason);
            }
            catch (MalformedObjectNameException e) {
                reason = "Parameters for Jolokia are malformed: " + e.getMessage();
                LOGGER.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable((String)reason);
            }
            catch (J4pException e) {
                reason = J4pException.class.getSimpleName() + " during Jolokia monitor call: " + e.getMessage();
                LOGGER.debug(reason, (Throwable)e);
                serviceStatus = PollStatus.unavailable((String)reason);
            }
            tracker.nextAttempt();
        }
        return serviceStatus;
    }
}

