/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.availability.svclayer;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.io.IOUtils;
import org.opennms.api.reporting.ReportFormat;
import org.opennms.api.reporting.ReportService;
import org.opennms.api.reporting.parameter.ReportParameters;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.dao.api.OnmsReportConfigDao;
import org.opennms.reporting.availability.AvailabilityCalculationException;
import org.opennms.reporting.availability.AvailabilityCalculator;
import org.opennms.reporting.availability.render.HTMLReportRenderer;
import org.opennms.reporting.availability.render.PDFReportRenderer;
import org.opennms.reporting.availability.render.ReportRenderer;
import org.opennms.reporting.core.svclayer.ParameterConversionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

public class AvailabilityReportService
implements ReportService {
    private static final Logger LOG = LoggerFactory.getLogger(AvailabilityReportService.class);
    private AvailabilityCalculator m_classicCalculator;
    private AvailabilityCalculator m_calendarCalculator;
    private OnmsReportConfigDao m_configDao;
    private ParameterConversionService m_parameterConversionService;
    private static final String LOG4J_CATEGORY = "reports";
    private static final String CAL_TYPE = "calendar";

    public void render(final String id, final String location, final ReportFormat format, final OutputStream outputStream) {
        Logging.withPrefix((String)LOG4J_CATEGORY, (Runnable)new Runnable(){

            @Override
            public void run() {
                FileInputStream inputStream = null;
                try {
                    inputStream = new FileInputStream(location);
                    AvailabilityReportService.this.render(id, inputStream, format, outputStream);
                }
                catch (FileNotFoundException e) {
                    LOG.error("could not open input file", (Throwable)e);
                }
            }
        });
    }

    private void render(final String id, final InputStream inputStream, final ReportFormat format, final OutputStream outputStream) {
        Logging.withPrefix((String)LOG4J_CATEGORY, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ReportRenderer renderer;
                    UrlResource xsltResource = switch (format) {
                        case ReportFormat.HTML -> {
                            LOG.debug("rendering as HTML");
                            renderer = new HTMLReportRenderer();
                            yield new UrlResource(AvailabilityReportService.this.m_configDao.getHtmlStylesheetLocation(id));
                        }
                        case ReportFormat.PDF -> {
                            LOG.debug("rendering as PDF");
                            renderer = new PDFReportRenderer();
                            yield new UrlResource(AvailabilityReportService.this.m_configDao.getPdfStylesheetLocation(id));
                        }
                        case ReportFormat.SVG -> {
                            LOG.debug("rendering as PDF with embedded SVG");
                            renderer = new PDFReportRenderer();
                            yield new UrlResource(AvailabilityReportService.this.m_configDao.getSvgStylesheetLocation(id));
                        }
                        default -> {
                            LOG.debug("rendering as HTML as no valid format found");
                            renderer = new HTMLReportRenderer();
                            yield new UrlResource(AvailabilityReportService.this.m_configDao.getHtmlStylesheetLocation(id));
                        }
                    };
                    String baseDir = System.getProperty("opennms.report.dir");
                    renderer.setBaseDir(baseDir);
                    renderer.render(inputStream, outputStream, (Resource)xsltResource);
                    outputStream.flush();
                }
                catch (Exception e) {
                    LOG.error("An error occurred rendering to {} format.", (Object)format.name(), (Object)e);
                }
            }
        });
    }

    public List<ReportFormat> getFormats(String id) {
        ArrayList<ReportFormat> formats = new ArrayList<ReportFormat>();
        if (this.m_configDao.getHtmlStylesheetLocation(id) != null) {
            formats.add(ReportFormat.HTML);
        }
        if (this.m_configDao.getPdfStylesheetLocation(id) != null) {
            formats.add(ReportFormat.PDF);
        }
        if (this.m_configDao.getSvgStylesheetLocation(id) != null) {
            formats.add(ReportFormat.SVG);
        }
        return formats;
    }

    public String run(final Map<String, Object> reportParms, final String reportId) {
        try {
            return (String)Logging.withPrefix((String)LOG4J_CATEGORY, (Callable)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    AvailabilityCalculator calculator;
                    String reportFileName = null;
                    LOG.debug("running OpenNMS database report {}", (Object)reportId);
                    if (AvailabilityReportService.this.m_configDao.getType(reportId).equalsIgnoreCase(AvailabilityReportService.CAL_TYPE)) {
                        calculator = AvailabilityReportService.this.m_calendarCalculator;
                        LOG.debug("Calendar report format selected");
                    } else {
                        calculator = AvailabilityReportService.this.m_classicCalculator;
                        LOG.debug("Classic report format selected");
                    }
                    calculator.setCategoryName((String)reportParms.get("reportCategory"));
                    LOG.debug("set availability calculator report category to: {}", (Object)calculator.getCategoryName());
                    calculator.setPeriodEndDate((Date)reportParms.get("endDate"));
                    LOG.debug("set availability calculator end date to: {}", (Object)calculator.getPeriodEndDate());
                    calculator.setLogoURL(AvailabilityReportService.this.m_configDao.getLogo(reportId));
                    calculator.setReportFormat("all");
                    LOG.debug("Starting Availability Report Calculations");
                    try {
                        calculator.calculate();
                        reportFileName = calculator.writeXML();
                    }
                    catch (AvailabilityCalculationException ce) {
                        LOG.error("Unable to calculate report data ", (Throwable)ce);
                    }
                    return reportFileName;
                }
            });
        }
        catch (Exception e) {
            LOG.warn("An error occurred while running report {}", (Object)reportId, (Object)e);
            return null;
        }
    }

    public void runAndRender(final Map<String, Object> reportParms, final String reportId, final ReportFormat format, final OutputStream outputStream) {
        Logging.withPrefix((String)LOG4J_CATEGORY, (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ByteArrayOutputStream out = null;
                BufferedOutputStream bout = null;
                try {
                    AvailabilityCalculator calculator;
                    out = new ByteArrayOutputStream();
                    bout = new BufferedOutputStream(out);
                    LOG.debug("running OpenNMS database report {}", (Object)reportId);
                    if (AvailabilityReportService.this.m_configDao.getType(reportId).equalsIgnoreCase(AvailabilityReportService.CAL_TYPE)) {
                        calculator = AvailabilityReportService.this.m_calendarCalculator;
                        LOG.debug("Calendar report format selected");
                    } else {
                        calculator = AvailabilityReportService.this.m_classicCalculator;
                        LOG.debug("Classic report format selected");
                    }
                    calculator.setCategoryName((String)reportParms.get("reportCategory"));
                    LOG.debug("set availability calculator report category to: {}", (Object)calculator.getCategoryName());
                    calculator.setPeriodEndDate((Date)reportParms.get("endDate"));
                    LOG.debug("set availability calculator end date to: {}", (Object)calculator.getPeriodEndDate());
                    calculator.setLogoURL(AvailabilityReportService.this.m_configDao.getLogo(reportId));
                    calculator.setReportFormat("all");
                    LOG.debug("Starting Availability Report Calculations");
                    calculator.calculate();
                    calculator.writeXML(bout);
                    AvailabilityReportService.this.render(reportId, new ByteArrayInputStream(out.toByteArray()), format, outputStream);
                    outputStream.flush();
                }
                catch (Exception e) {
                    try {
                        LOG.warn("An error occurred while rendering report {}", (Object)reportId, (Object)e);
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(bout);
                        IOUtils.closeQuietly((OutputStream)out);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((OutputStream)bout);
                    IOUtils.closeQuietly((OutputStream)out);
                }
                IOUtils.closeQuietly((OutputStream)bout);
                IOUtils.closeQuietly((OutputStream)out);
            }
        });
    }

    public ReportParameters getParameters(String ReportId) {
        return this.m_parameterConversionService.convert(this.m_configDao.getParameters(ReportId));
    }

    public void setCalendarCalculator(AvailabilityCalculator calculator) {
        this.m_calendarCalculator = calculator;
    }

    public void setClassicCalculator(AvailabilityCalculator calulator) {
        this.m_classicCalculator = calulator;
    }

    public void setConfigDao(OnmsReportConfigDao configDao) {
        this.m_configDao = configDao;
    }

    public void setParameterConversionService(ParameterConversionService parameterConversionService) {
        this.m_parameterConversionService = parameterConversionService;
    }
}

