/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.availability;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import org.opennms.core.logging.Logging;
import org.opennms.netmgt.config.CategoryFactory;
import org.opennms.netmgt.config.api.CatFactory;
import org.opennms.netmgt.config.categories.CategoryGroup;
import org.opennms.netmgt.config.categories.Catinfo;
import org.opennms.reporting.availability.AvailCalculations;
import org.opennms.reporting.availability.CatSections;
import org.opennms.reporting.availability.Categories;
import org.opennms.reporting.availability.Category;
import org.opennms.reporting.availability.Created;
import org.opennms.reporting.availability.Report;
import org.opennms.reporting.availability.Section;
import org.opennms.reporting.availability.svclayer.AvailabilityDataService;
import org.opennms.reporting.datablock.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvailabilityData {
    private static final Logger LOG = LoggerFactory.getLogger(AvailabilityData.class);
    private static final String LOG4J_CATEGORY = "reports";
    private List<Node> m_nodes;
    private long m_endTime;
    private long m_startTime;
    private long m_lastMonthEndTime;
    private int m_daysInLastMonth;
    CatFactory m_catFactory;
    private int m_sectionIndex = 0;
    private AvailabilityDataService m_availabilityDataService;

    public void fillReport(String categoryName, Report report, String format, String monthFormat, String startMonth, String startDate, String startYear) throws IOException, Exception {
        GregorianCalendar cal = new GregorianCalendar();
        cal.set(5, Integer.parseInt(startDate));
        cal.set(2, Integer.parseInt(startMonth));
        cal.set(1, Integer.parseInt(startYear));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        this.generateData(categoryName, report, format, monthFormat, new Date(cal.getTimeInMillis()));
    }

    public void fillReport(String categoryName, Report report, String format, String monthFormat, Date periodEndDate) throws IOException, Exception {
        this.generateData(categoryName, report, format, monthFormat, periodEndDate);
    }

    private void generateData(final String categoryName, final Report report, final String format, final String monthFormat, final Date periodEndDate) throws IOException, Exception {
        Logging.withPrefix((String)LOG4J_CATEGORY, (Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                LOG.debug("Inside AvailabilityData");
                AvailabilityData.this.m_nodes = new ArrayList<Node>();
                AvailabilityData.this.initializeInterval(periodEndDate);
                Catinfo config = null;
                try {
                    CategoryFactory.init();
                    AvailabilityData.this.m_catFactory = CategoryFactory.getInstance();
                    config = AvailabilityData.this.m_catFactory.getConfig();
                }
                catch (IOException e) {
                    LOG.error("Initializing CategoryFactory", (Throwable)e);
                    throw e;
                }
                LOG.debug("CATEGORY {}", (Object)categoryName);
                AvailabilityData.this.m_catFactory.getReadLock().lock();
                try {
                    if (categoryName.equals("") || categoryName.equals("all")) {
                        int catCount = 0;
                        LOG.debug("catCount {}", (Object)catCount);
                        for (CategoryGroup cg : config.getCategoryGroups()) {
                            for (org.opennms.netmgt.config.categories.Category cat : cg.getCategories()) {
                                LOG.debug("CATEGORY {}", (Object)cat.getLabel());
                                AvailabilityData.this.populateDataStructures(cat, report, format, monthFormat, ++catCount);
                            }
                        }
                        LOG.debug("catCount {}", (Object)catCount);
                    } else {
                        org.opennms.netmgt.config.categories.Category cat = AvailabilityData.this.m_catFactory.getCategory(categoryName);
                        LOG.debug("CATEGORY - now populating data structures {}", (Object)cat.getLabel());
                        AvailabilityData.this.populateDataStructures(cat, report, format, monthFormat, 1);
                    }
                    SimpleDateFormat simplePeriod = new SimpleDateFormat("MMMMMMMMMMM dd, yyyy");
                    String reportPeriod = simplePeriod.format(new Date(AvailabilityData.this.m_startTime)) + " - " + simplePeriod.format(new Date(AvailabilityData.this.m_endTime));
                    Created created = report.getCreated();
                    if (created == null) {
                        created = new Created();
                    }
                    created.setPeriod(reportPeriod);
                    report.setCreated(created);
                }
                finally {
                    AvailabilityData.this.m_catFactory.getReadLock().unlock();
                }
                LOG.debug("After availCalculations");
                return null;
            }
        });
    }

    private void populateDataStructures(org.opennms.netmgt.config.categories.Category cat, Report report, String format, String monthFormat, int catIndex) throws Exception {
        LOG.debug("Inside populate data Structures {}", (Object)catIndex);
        report.setCatCount(catIndex);
        LOG.debug("Inside populate data Structures");
        try {
            ArrayList<String> monitoredServices = new ArrayList<String>(cat.getServices());
            if (this.m_availabilityDataService == null) {
                LOG.debug("DATA SERVICE IS NULL");
                throw new IllegalStateException("Data service is null");
            }
            this.m_nodes = this.m_availabilityDataService.getNodes(cat, this.m_startTime, this.m_endTime);
            LOG.debug("Nodes {}", this.m_nodes);
            ListIterator<Node> cleanNodes = this.m_nodes.listIterator();
            while (cleanNodes.hasNext()) {
                Node node = cleanNodes.next();
                if (node == null || node.hasOutages()) continue;
                LOG.debug("Removing node: {}", (Object)node);
                cleanNodes.remove();
            }
            LOG.debug("Cleaned Nodes {}", this.m_nodes);
            Map<Double, List<String>> topOffenders = this.getPercentNode();
            LOG.debug("TOP OFFENDERS {}", topOffenders);
            if (this.m_nodes.size() <= 0) {
                this.m_nodes = null;
            }
            if (this.m_nodes != null) {
                AvailCalculations availCalculations = new AvailCalculations(this.m_nodes, this.m_endTime, this.m_lastMonthEndTime, monitoredServices, report, topOffenders, cat.getWarningThreshold(), cat.getNormalThreshold(), cat.getComment().orElse(null), cat.getLabel(), format, monthFormat, catIndex, this.m_sectionIndex);
                this.m_sectionIndex = availCalculations.getSectionIndex();
                report.setSectionCount(this.m_sectionIndex - 1);
            } else {
                Category category = new Category();
                category.setCatComments(cat.getComment().orElse(null));
                category.setCatName(cat.getLabel());
                category.setCatIndex(catIndex);
                category.setNodeCount(0);
                category.setIpaddrCount(0);
                category.setServiceCount(0);
                Section section = new Section();
                section.setSectionIndex(this.m_sectionIndex);
                CatSections catSections = new CatSections();
                catSections.addSection(section);
                category.addCatSections(catSections);
                Categories categories = report.getCategories();
                categories.addCategory(category);
                report.setCategories(categories);
                report.setSectionCount(this.m_sectionIndex);
                ++this.m_sectionIndex;
            }
        }
        catch (Throwable e) {
            LOG.error("Exception has occurred", e);
            throw new Exception(e);
        }
    }

    private void initializeInterval(Date periodEndDate) {
        GregorianCalendar tempCal = new GregorianCalendar();
        tempCal.setTime(periodEndDate);
        tempCal.set(11, 23);
        tempCal.set(12, 59);
        tempCal.set(13, 59);
        tempCal.set(14, 999);
        this.m_endTime = tempCal.getTimeInMillis();
        ((Calendar)tempCal).add(1, -1);
        tempCal.set(5, 1);
        tempCal.set(11, 0);
        tempCal.set(12, 0);
        tempCal.set(13, 0);
        tempCal.set(14, 0);
        this.m_startTime = tempCal.getTimeInMillis();
        tempCal.setTimeInMillis(this.m_endTime);
        ((Calendar)tempCal).add(2, -1);
        this.m_daysInLastMonth = ((Calendar)tempCal).getActualMaximum(5);
        tempCal.set(5, this.m_daysInLastMonth);
        tempCal.set(11, 23);
        tempCal.set(12, 59);
        tempCal.set(13, 59);
        tempCal.set(14, 999);
        this.m_lastMonthEndTime = tempCal.getTimeInMillis();
    }

    public List<Node> getNodes() {
        return this.m_nodes;
    }

    public Map<Double, List<String>> getPercentNode() {
        int days = this.m_daysInLastMonth;
        long endTime = this.m_lastMonthEndTime;
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTimeInMillis(endTime);
        ((Calendar)cal).add(5, -1 * days);
        long rollingWindow = endTime - cal.getTime().getTime();
        long startTime = cal.getTime().getTime();
        LOG.debug("getPercentNode: Start time {}", (Object)new Date(startTime));
        LOG.debug("getPercentNode: End time {}", (Object)new Date(endTime));
        TreeMap<Double, List<String>> percentNode = new TreeMap<Double, List<String>>();
        for (Node node : this.m_nodes) {
            if (node == null) continue;
            double percent = node.getPercentAvail(endTime, rollingWindow);
            String nodeName = node.getName();
            LOG.debug("Node {} {} %", (Object)nodeName, (Object)percent);
            if (!(percent < 100.0)) continue;
            List<String> nodeNames = percentNode.get(new Double(percent));
            if (nodeNames == null) {
                nodeNames = new ArrayList<String>();
            }
            nodeNames.add(nodeName);
            percentNode.put(new Double(percent), nodeNames);
        }
        LOG.debug("Percent node {}", percentNode);
        return percentNode;
    }

    public void setAvailabilityDataService(AvailabilityDataService availabilityDataService) {
        LOG.debug("setting m_availabilityDataService");
        this.m_availabilityDataService = availabilityDataService;
    }
}

