/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.api.info;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import org.opennms.netmgt.graph.api.info.Severity;
import org.opennms.netmgt.model.OnmsSeverity;

public class StatusInfo {
    private final ImmutableMap<String, Object> properties;

    public StatusInfo(StatusInfoBuilder builder) {
        this.properties = ImmutableMap.copyOf(builder.properties);
    }

    public Severity getSeverity() {
        return (Severity)((Object)this.getProperty("severity"));
    }

    public Long getCount() {
        return (Long)this.getProperty("count");
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public <T> T getProperty(String name) {
        Objects.requireNonNull(name);
        return (T)this.properties.get((Object)name);
    }

    public static StatusInfoBuilder defaultStatus() {
        return StatusInfo.builder(Severity.Normal);
    }

    public static StatusInfoBuilder builder(Severity severity) {
        Objects.requireNonNull(severity);
        return new StatusInfoBuilder().severity(severity).count(0L);
    }

    public static StatusInfoBuilder builder(OnmsSeverity severity) {
        Objects.requireNonNull(severity);
        return StatusInfo.builder(Severity.createFrom(severity));
    }

    public static StatusInfoBuilder from(StatusInfo status) {
        return new StatusInfoBuilder().properties(status.getProperties());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StatusInfo that = (StatusInfo)o;
        return Objects.equals(this.properties, that.properties);
    }

    public int hashCode() {
        return Objects.hash(this.properties);
    }

    public String toString() {
        return new StringJoiner(", ", StatusInfo.class.getSimpleName() + "[", "]").add("severity=" + this.getSeverity()).add("count=" + this.getCount()).toString();
    }

    public static final class StatusInfoBuilder {
        private final Map<String, Object> properties = Maps.newHashMap();

        private StatusInfoBuilder() {
        }

        public StatusInfoBuilder severity(OnmsSeverity severity) {
            this.severity(Severity.createFrom(severity));
            return this;
        }

        public StatusInfoBuilder severity(Severity severity) {
            this.property("severity", severity);
            return this;
        }

        public StatusInfoBuilder count(long count) {
            Preconditions.checkArgument((count >= 0L ? 1 : 0) != 0, (Object)"count must be >= 0");
            this.property("count", count);
            return this;
        }

        public <T> StatusInfoBuilder property(String name, T value) {
            Objects.requireNonNull(name);
            Objects.requireNonNull(value);
            this.properties.put(name, value);
            return this;
        }

        public StatusInfoBuilder properties(Map<String, Object> properties) {
            Objects.requireNonNull(properties);
            if (!properties.containsKey("severity")) {
                throw new IllegalArgumentException("Severity must be set");
            }
            this.properties.putAll(properties);
            return this;
        }

        public <T> T getProperty(String name) {
            Objects.requireNonNull(name);
            return (T)this.properties.get(name);
        }

        public StatusInfo build() {
            return new StatusInfo(this);
        }

        public Severity getSeverity() {
            return (Severity)((Object)this.getProperty("severity"));
        }

        public Long getCount() {
            Object value = this.getProperty("count");
            if (value != null) {
                return (Long)value;
            }
            return 0L;
        }
    }

    static interface Properties {
        public static final String Severity = "severity";
        public static final String Count = "count";
    }
}

