/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.service;

import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;

@XmlRootElement(name="argument")
@XmlAccessorType(value=XmlAccessType.FIELD)
@ValidateUsing(value="service-configuration.xsd")
public class Argument
implements Serializable {
    private static final long serialVersionUID = 2L;
    @XmlValue
    private String m_value;
    @XmlAttribute(name="type", required=true)
    private String m_type;

    public Argument() {
    }

    public Argument(String type, String value) {
        this.setType(type);
        this.setValue(value);
    }

    public Optional<String> getValue() {
        return Optional.ofNullable(this.m_value);
    }

    public void setValue(String value) {
        this.m_value = ConfigUtils.normalizeString(value);
    }

    public String getType() {
        return this.m_type;
    }

    public void setType(String type) {
        this.m_type = ConfigUtils.assertNotEmpty(type, "type");
    }

    public int hashCode() {
        return Objects.hash(this.m_value, this.m_type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Argument) {
            Argument that = (Argument)obj;
            return Objects.equals(this.m_value, that.m_value) && Objects.equals(this.m_type, that.m_type);
        }
        return false;
    }
}

