/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.decision;

import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.opennms.netmgt.flows.classification.FilterService;
import org.opennms.netmgt.flows.classification.IpAddr;
import org.opennms.netmgt.flows.classification.internal.decision.Bounds;
import org.opennms.netmgt.flows.classification.internal.decision.Classifier;
import org.opennms.netmgt.flows.classification.internal.decision.Threshold;
import org.opennms.netmgt.flows.classification.internal.value.IpValue;
import org.opennms.netmgt.flows.classification.internal.value.PortValue;
import org.opennms.netmgt.flows.classification.internal.value.ProtocolValue;
import org.opennms.netmgt.flows.classification.persistence.api.RuleDefinition;

public class PreprocessedRule {
    public final RuleDefinition ruleDefinition;
    public final ProtocolValue protocol;
    public final PortValue srcPort;
    public final PortValue dstPort;
    public final IpValue srcAddr;
    public final IpValue dstAddr;
    public final Set<Threshold> thresholds;

    public static PreprocessedRule of(RuleDefinition rule) {
        return new PreprocessedRule(rule, rule.hasProtocolDefinition() ? ProtocolValue.of(rule.getProtocol()) : null, rule.hasSrcPortDefinition() ? PortValue.of(rule.getSrcPort()) : null, rule.hasDstPortDefinition() ? PortValue.of(rule.getDstPort()) : null, rule.hasSrcAddressDefinition() ? IpValue.of(rule.getSrcAddress()) : null, rule.hasDstAddressDefinition() ? IpValue.of(rule.getDstAddress()) : null);
    }

    private static Stream<Threshold> protocolThresholds(ProtocolValue value) {
        return value == null ? Stream.empty() : value.getProtocols().stream().map(Threshold.Protocol::new);
    }

    private static Stream<Threshold> portThresholds(PortValue value, Function<Integer, Threshold> thresholdCreator) {
        return value == null ? Stream.empty() : value.getPortRanges().stream().flatMap(range -> Stream.of(range.getBegin(), range.getEnd())).map(thresholdCreator);
    }

    private static Stream<Threshold> addressThresholds(IpValue value, Function<IpAddr, Threshold> thresholdCreator) {
        return value == null ? Stream.empty() : value.getIpAddressRanges().stream().flatMap(range -> Stream.of(range.begin, range.end)).map(thresholdCreator);
    }

    public PreprocessedRule(RuleDefinition ruleDefinition, ProtocolValue protocol, PortValue srcPort, PortValue dstPort, IpValue srcAddr, IpValue dstAddr) {
        this.ruleDefinition = ruleDefinition;
        this.protocol = protocol;
        this.srcPort = srcPort;
        this.dstPort = dstPort;
        this.srcAddr = srcAddr;
        this.dstAddr = dstAddr;
        this.thresholds = Stream.of(PreprocessedRule.protocolThresholds(protocol), PreprocessedRule.portThresholds(srcPort, Threshold.SrcPort::new), PreprocessedRule.portThresholds(dstPort, Threshold.DstPort::new), PreprocessedRule.addressThresholds(srcAddr, Threshold.SrcAddress::new), PreprocessedRule.addressThresholds(dstAddr, Threshold.DstAddress::new)).flatMap(Function.identity()).collect(Collectors.toSet());
    }

    public Classifier createClassifier(FilterService filterService, Bounds bounds) {
        return Classifier.of(this, filterService, bounds);
    }

    public PreprocessedRule reverse() {
        return new PreprocessedRule(this.ruleDefinition.reversedRule(), this.protocol, this.dstPort, this.srcPort, this.dstAddr, this.srcAddr);
    }
}

