/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.csv;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.opennms.netmgt.flows.classification.internal.csv.CsvServiceImpl;
import org.opennms.netmgt.flows.classification.persistence.api.Rule;
import org.opennms.netmgt.flows.classification.persistence.api.RuleBuilder;

public class CsvBuilder {
    private final List<Rule> rules = new ArrayList<Rule>();
    private boolean includeHeader = true;

    public CsvBuilder withHeader(boolean includeHeader) {
        this.includeHeader = includeHeader;
        return this;
    }

    public CsvBuilder withRule(RuleBuilder ruleBuilder) {
        Objects.requireNonNull(ruleBuilder);
        this.withRule(ruleBuilder.build());
        return this;
    }

    public CsvBuilder withRule(Rule rule) {
        Objects.requireNonNull(rule);
        this.rules.add(rule);
        return this;
    }

    public CsvBuilder withRules(List<Rule> rules) {
        Objects.requireNonNull(rules);
        this.rules.addAll(rules);
        return this;
    }

    public String build() {
        StringBuilder csv = new StringBuilder();
        if (this.includeHeader) {
            csv.append(CsvServiceImpl.HEADERS_STRING);
        }
        String rowFormat = IntStream.range(0, CsvServiceImpl.HEADERS.length).mapToObj(i -> "%s").collect(Collectors.joining(";"));
        csv.append(this.rules.stream().map(rule -> String.format(rowFormat, rule.getName() == null ? "" : rule.getName(), rule.getProtocol() == null ? "" : rule.getProtocol(), rule.getSrcAddress() == null ? "" : rule.getSrcAddress(), rule.getSrcPort() == null ? "" : rule.getSrcPort(), rule.getDstAddress() == null ? "" : rule.getDstAddress(), rule.getDstPort() == null ? "" : rule.getDstPort(), rule.getExporterFilter() == null ? "" : rule.getExporterFilter(), rule.isOmnidirectional() ? "true" : "false")).collect(Collectors.joining("\n")));
        return csv.toString();
    }
}

