/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.config.osgi.cm;

import java.io.IOException;
import org.opennms.features.config.osgi.cm.CmIdentifierUtil;
import org.opennms.features.config.osgi.cm.CmPersistenceManager;
import org.opennms.features.config.osgi.del.MigratedServices;
import org.opennms.features.config.service.api.ConfigUpdateInfo;
import org.opennms.features.config.service.api.ConfigurationManagerService;
import org.opennms.features.config.service.api.EventType;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CallbackManager {
    private static final Logger LOG = LoggerFactory.getLogger(CallbackManager.class);

    CallbackManager() {
    }

    void registerCallbacks(ConfigurationAdmin configurationAdmin, ConfigurationManagerService cm, CmPersistenceManager cmPersistenceManager) {
        ConfigUpdateInfo key;
        for (String pid : MigratedServices.PIDS_SINGLE_INSTANCE) {
            key = new ConfigUpdateInfo(pid);
            cm.registerEventHandler(EventType.UPDATE, key, k -> this.updateConfig(configurationAdmin, cmPersistenceManager, (ConfigUpdateInfo)k));
        }
        for (String configName : MigratedServices.PIDS_MULTI_INSTANCE) {
            key = new ConfigUpdateInfo(configName, ConfigUpdateInfo.WILDCARD_ID);
            cm.registerEventHandler(EventType.CREATE, key, k -> this.createConfig(configurationAdmin, cmPersistenceManager, (ConfigUpdateInfo)k));
            cm.registerEventHandler(EventType.UPDATE, key, k -> this.updateConfig(configurationAdmin, cmPersistenceManager, (ConfigUpdateInfo)k));
            cm.registerEventHandler(EventType.DELETE, key, k -> this.deleteConfig(configurationAdmin, cmPersistenceManager, (ConfigUpdateInfo)k));
        }
    }

    private void createConfig(ConfigurationAdmin configurationAdmin, CmPersistenceManager cmPersistenceManager, ConfigUpdateInfo key) {
        String cmPid = CmIdentifierUtil.cmIdentifierToPid(key);
        try {
            Configuration config = configurationAdmin.createFactoryConfiguration(key.getConfigName(), "?");
            cmPersistenceManager.setPidMapping(config.getPid(), cmPid);
            config.update();
        }
        catch (IOException e) {
            LOG.error("Cannot create configuration for pid=" + cmPid, (Throwable)e);
        }
    }

    private void updateConfig(ConfigurationAdmin configurationAdmin, CmPersistenceManager cmPersistenceManager, ConfigUpdateInfo identifier) {
        String osgiPid = cmPersistenceManager.getOsgiPid(identifier);
        try {
            configurationAdmin.getConfiguration(osgiPid).update();
        }
        catch (IOException e) {
            LOG.error("Cannot update configuration for identifier=" + identifier, (Throwable)e);
        }
    }

    private void deleteConfig(ConfigurationAdmin configurationAdmin, CmPersistenceManager cmPersistenceManager, ConfigUpdateInfo identifier) {
        String osgiPid = cmPersistenceManager.getOsgiPid(identifier);
        try {
            configurationAdmin.getConfiguration(osgiPid).delete();
        }
        catch (IOException e) {
            LOG.error("Cannot delete configuration for identifier=" + identifier, (Throwable)e);
        }
    }
}

