/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.netmgt.enlinkd.model.BridgeStpLink;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;

public class Dot1dStpPortTableTracker
extends TableTracker {
    public static final SnmpObjId DOT1D_STP_PORT_OID = SnmpObjId.get((String)".1.3.6.1.2.1.17.2.15.1.1");
    public static final SnmpObjId DOT1D_STP_PORT_PRIORITY_OID = SnmpObjId.get((String)".1.3.6.1.2.1.17.2.15.1.2");
    public static final SnmpObjId DOT1D_STP_PORT_STATE_OID = SnmpObjId.get((String)".1.3.6.1.2.1.17.2.15.1.3");
    public static final SnmpObjId DOT1D_STP_PORT_ENABLE_OID = SnmpObjId.get((String)".1.3.6.1.2.1.17.2.15.1.4");
    public static final SnmpObjId DOT1D_STP_PORT_PATH_COST_OID = SnmpObjId.get((String)".1.3.6.1.2.1.17.2.15.1.5");
    public static final SnmpObjId DOT1D_STP_PORT_DESIGNATED_ROOT_OID = SnmpObjId.get((String)".1.3.6.1.2.1.17.2.15.1.6");
    public static final SnmpObjId DOT1D_STP_PORT_DESIGNATED_COST_OID = SnmpObjId.get((String)".1.3.6.1.2.1.17.2.15.1.7");
    public static final SnmpObjId DOT1D_STP_PORT_DESIGNATED_BRIDGE_OID = SnmpObjId.get((String)".1.3.6.1.2.1.17.2.15.1.8");
    public static final SnmpObjId DOT1D_STP_PORT_DESIGNATED_PORT_OID = SnmpObjId.get((String)".1.3.6.1.2.1.17.2.15.1.9");
    public static final String DOT1D_STP_PORT = "dot1dStpPort";
    public static final String DOT1D_STP_PORT_PRIORITY = "dot1dStpPortPriority";
    public static final String DOT1D_STP_PORT_STATE = "dot1dStpPortState";
    public static final String DOT1D_STP_PORT_ENABLE = "dot1dStpPortEnable";
    public static final String DOT1D_STP_PORT_PATH_COST = "dot1dStpPortPathCost";
    public static final String DOT1D_STP_PORT_DESIGNATED_ROOT = "dot1dStpPortDesignatedRoot";
    public static final String DOT1D_STP_PORT_DESIGNATED_COST = "dot1dStpPortDesignatedCost";
    public static final String DOT1D_STP_PORT_DESIGNATED_BRIDGE = "dot1dStpPortDesignatedBridge";
    public static final String DOT1D_STP_PORT_DESIGNATED_PORT = "dot1dStpPortDesignatedPort";
    public static final SnmpObjId[] stpport_elemList = new SnmpObjId[]{DOT1D_STP_PORT_OID, DOT1D_STP_PORT_PRIORITY_OID, DOT1D_STP_PORT_STATE_OID, DOT1D_STP_PORT_ENABLE_OID, DOT1D_STP_PORT_PATH_COST_OID, DOT1D_STP_PORT_DESIGNATED_ROOT_OID, DOT1D_STP_PORT_DESIGNATED_COST_OID, DOT1D_STP_PORT_DESIGNATED_BRIDGE_OID, DOT1D_STP_PORT_DESIGNATED_PORT_OID};

    public Dot1dStpPortTableTracker() {
        super(stpport_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new Dot1dStpPortRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processDot1dStpPortRow((Dot1dStpPortRow)row);
    }

    public void processDot1dStpPortRow(Dot1dStpPortRow row) {
        System.out.printf("\t\t%s (%s)= %s \n", DOT1D_STP_PORT_OID + "." + row.getInstance().toString(), DOT1D_STP_PORT, row.getDot1dStpPort());
        System.out.printf("\t\t%s (%s)= %s \n", DOT1D_STP_PORT_PRIORITY_OID + "." + row.getInstance().toString(), DOT1D_STP_PORT_PRIORITY, row.getDot1dStpPortPriority());
        System.out.printf("\t\t%s (%s)= %s (%s)\n", DOT1D_STP_PORT_STATE_OID + "." + row.getInstance().toString(), DOT1D_STP_PORT_STATE, row.getDot1dStpPortState(), BridgeStpLink.BridgeDot1dStpPortState.get((Integer)row.getDot1dStpPortState()));
        System.out.printf("\t\t%s (%s)= %s (%s)\n", DOT1D_STP_PORT_ENABLE_OID + "." + row.getInstance().toString(), DOT1D_STP_PORT_ENABLE, row.getDot1dStpPortEnable(), BridgeStpLink.BridgeDot1dStpPortEnable.get((Integer)row.getDot1dStpPortEnable()));
        System.out.printf("\t\t%s (%s)= %s \n", DOT1D_STP_PORT_PATH_COST_OID + "." + row.getInstance().toString(), DOT1D_STP_PORT_PATH_COST, row.getDot1dStpPortPathCost());
        System.out.printf("\t\t%s (%s)= %s \n", DOT1D_STP_PORT_DESIGNATED_ROOT_OID + "." + row.getInstance().toString(), DOT1D_STP_PORT_DESIGNATED_ROOT, row.getDot1dStpPortDesignatedRoot());
        System.out.printf("\t\t%s (%s)= %s \n", DOT1D_STP_PORT_DESIGNATED_COST_OID + "." + row.getInstance().toString(), DOT1D_STP_PORT_DESIGNATED_COST, row.getDot1dStpPortDesignatedCost());
        System.out.printf("\t\t%s (%s)= %s \n", DOT1D_STP_PORT_DESIGNATED_BRIDGE_OID + "." + row.getInstance().toString(), DOT1D_STP_PORT_DESIGNATED_BRIDGE, row.getDot1dStpPortDesignatedBridge());
        System.out.printf("\t\t%s (%s)= %s \n", DOT1D_STP_PORT_DESIGNATED_PORT_OID + "." + row.getInstance().toString(), DOT1D_STP_PORT_DESIGNATED_PORT, row.getDot1dStpPortDesignatedPort());
    }

    public static class Dot1dStpPortRow
    extends SnmpRowResult {
        public Dot1dStpPortRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
        }

        public Integer getDot1dStpPort() {
            return this.getValue(DOT1D_STP_PORT_OID).toInt();
        }

        public Integer getDot1dStpPortPriority() {
            return this.getValue(DOT1D_STP_PORT_PRIORITY_OID).toInt();
        }

        public Integer getDot1dStpPortState() {
            return this.getValue(DOT1D_STP_PORT_STATE_OID).toInt();
        }

        public Integer getDot1dStpPortEnable() {
            return this.getValue(DOT1D_STP_PORT_ENABLE_OID).toInt();
        }

        public Integer getDot1dStpPortPathCost() {
            return this.getValue(DOT1D_STP_PORT_PATH_COST_OID).toInt();
        }

        public String getDot1dStpPortDesignatedRoot() {
            return this.getValue(DOT1D_STP_PORT_DESIGNATED_ROOT_OID).toHexString();
        }

        public Integer getDot1dStpPortDesignatedCost() {
            return this.getValue(DOT1D_STP_PORT_DESIGNATED_COST_OID).toInt();
        }

        public String getDot1dStpPortDesignatedBridge() {
            return this.getValue(DOT1D_STP_PORT_DESIGNATED_BRIDGE_OID).toHexString();
        }

        public String getDot1dStpPortDesignatedPort() {
            return this.getValue(DOT1D_STP_PORT_DESIGNATED_PORT_OID).toHexString();
        }

        public BridgeStpLink getLink() {
            BridgeStpLink link = new BridgeStpLink();
            link.setStpPort(this.getDot1dStpPort());
            link.setStpPortPriority(this.getDot1dStpPortPriority());
            link.setStpPortState(BridgeStpLink.BridgeDot1dStpPortState.get((Integer)this.getDot1dStpPortState()));
            link.setStpPortEnable(BridgeStpLink.BridgeDot1dStpPortEnable.get((Integer)this.getDot1dStpPortEnable()));
            link.setStpPortPathCost(this.getDot1dStpPortPathCost());
            link.setDesignatedRoot(this.getDot1dStpPortDesignatedRoot());
            link.setDesignatedCost(this.getDot1dStpPortDesignatedCost());
            link.setDesignatedBridge(this.getDot1dStpPortDesignatedBridge());
            link.setDesignatedPort(this.getDot1dStpPortDesignatedPort());
            return link;
        }
    }
}

