/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.springframework.security;

import org.opennms.netmgt.config.UserManager;
import org.opennms.web.springframework.security.OnmsAuthenticationToken;
import org.opennms.web.springframework.security.SpringSecurityUser;
import org.opennms.web.springframework.security.SpringSecurityUserDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.util.Assert;

public class HybridOpenNMSUserAuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(HybridOpenNMSUserAuthenticationProvider.class);
    private UserManager m_userManager = null;
    private SpringSecurityUserDao m_userDao = null;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_userManager);
        Assert.notNull((Object)this.m_userDao);
    }

    public UserManager getUserManager() {
        return this.m_userManager;
    }

    public void setUserManager(UserManager userManager) {
        this.m_userManager = userManager;
    }

    public SpringSecurityUserDao getUserDao() {
        return this.m_userDao;
    }

    public void setUserDao(SpringSecurityUserDao userDao) {
        this.m_userDao = userDao;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String authUsername = authentication.getPrincipal().toString();
        String authPassword = authentication.getCredentials().toString();
        SpringSecurityUser user = this.m_userDao.getByUsername(authUsername);
        if (user == null) {
            LOG.warn("User not found: " + authUsername);
            throw new BadCredentialsException("Bad credentials");
        }
        try {
            this.checkUserPassword(authUsername, authPassword, user);
        }
        catch (AuthenticationException e) {
            try {
                this.m_userManager.reload();
            }
            catch (Exception reloadException) {
                LOG.debug("Failed to reload UserManager.", (Throwable)reloadException);
            }
            this.checkUserPassword(authUsername, authPassword, user);
        }
        if (user.getAuthorities().size() == 0) {
            user.addAuthority(SpringSecurityUserDao.ROLE_USER);
        }
        return new OnmsAuthenticationToken(user);
    }

    protected void checkUserPassword(String authUsername, String authPassword, SpringSecurityUser user) throws AuthenticationException {
        String existingPassword = user.getPassword();
        boolean hasUser = false;
        try {
            hasUser = this.m_userManager.hasUser(user.getUsername());
        }
        catch (Throwable e) {
            throw new AuthenticationServiceException("An error occurred while checking for " + authUsername + " in the UserManager", e);
        }
        if (hasUser) {
            if (!this.m_userManager.comparePasswords(authUsername, authPassword)) {
                LOG.warn("Password auth failed for user: " + authUsername);
                throw new BadCredentialsException("Bad credentials");
            }
        } else if (!this.m_userManager.checkSaltedPassword(authPassword, existingPassword)) {
            LOG.warn("Salted password auth failed for user: " + authUsername);
            throw new BadCredentialsException("Bad credentials");
        }
    }

    public boolean supports(Class<?> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

