/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.mate.api;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.opennms.core.mate.api.ContextKey;
import org.opennms.core.mate.api.Scope;

public class ObjectScope<T>
implements Scope {
    private final Scope.ScopeName scopeName;
    private final T object;
    private final Map<ContextKey, Function<T, Optional<String>>> accessors = Maps.newHashMap();

    public ObjectScope(Scope.ScopeName scopeName, T object) {
        this.scopeName = Objects.requireNonNull(scopeName);
        this.object = Objects.requireNonNull(object);
    }

    @Override
    public Optional<Scope.ScopeValue> get(ContextKey contextKey) {
        return this.accessors.getOrDefault(contextKey, missing -> Optional.empty()).apply(this.object).map(value -> new Scope.ScopeValue(this.scopeName, (String)value));
    }

    @Override
    public Set<ContextKey> keys() {
        return this.accessors.keySet();
    }

    public ObjectScope<T> map(String context, String key, Function<T, Optional<String>> accessor) {
        this.accessors.put(new ContextKey(context, key), accessor);
        return this;
    }
}

