/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.dialogs;

import com.vaadin.server.JsonPaintTarget;
import com.vaadin.ui.Button;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import java.io.Serializable;
import org.vaadin.dialogs.DefaultConfirmDialogFactory;

public class ConfirmDialog
extends Window {
    private static final long serialVersionUID = -2363125714643244070L;
    public static final String DIALOG_ID = "confirmdialog-window";
    public static final String MESSAGE_ID = "confirmdialog-message";
    public static final String OK_ID = "confirmdialog-ok-button";
    public static final String NOT_OK_ID = "confirmdialog-not-ok-button";
    public static final String CANCEL_ID = "confirmdialog-cancel-button";
    private static Factory factoryInstance;
    private Listener confirmListener = null;
    private Boolean isConfirmed = null;
    private Label messageLabel = null;
    private Button okBtn = null;
    private Button notOkBtn = null;
    private Button cancelBtn = null;
    private String originalMessageText;
    private ContentMode msgContentMode = ContentMode.TEXT_WITH_NEWLINES;

    public static Factory getFactory() {
        if (factoryInstance == null) {
            factoryInstance = new DefaultConfirmDialogFactory();
        }
        return factoryInstance;
    }

    public static void setFactory(Factory newFactory) {
        factoryInstance = newFactory;
    }

    public static ConfirmDialog show(UI ui, Listener listener) {
        return ConfirmDialog.show(ui, null, null, null, null, listener);
    }

    public static ConfirmDialog show(UI ui, String message, Listener listener) {
        return ConfirmDialog.show(ui, null, message, null, null, listener);
    }

    public static ConfirmDialog show(UI ui, String windowCaption, String message, String okCaption, String cancelCaption, String notOKCaption, Listener listener) {
        ConfirmDialog d = ConfirmDialog.getFactory().create(windowCaption, message, okCaption, cancelCaption, notOKCaption);
        d.show(ui, listener, true);
        return d;
    }

    public static ConfirmDialog show(UI ui, String windowCaption, String message, String okCaption, String cancelCaption, Listener listener) {
        ConfirmDialog d = ConfirmDialog.getFactory().create(windowCaption, message, okCaption, cancelCaption, null);
        d.show(ui, listener, true);
        return d;
    }

    public static ConfirmDialog show(UI ui, String windowCaption, String message, String okCaption, String cancelCaption, final Runnable r) {
        ConfirmDialog d = ConfirmDialog.getFactory().create(windowCaption, message, okCaption, cancelCaption, null);
        d.show(ui, new Listener(){
            private static final long serialVersionUID = 1L;

            @Override
            public void onClose(ConfirmDialog dialog) {
                if (dialog.isConfirmed()) {
                    r.run();
                }
            }
        }, true);
        return d;
    }

    public final void show(UI ui, Listener listener, boolean modal) {
        this.confirmListener = listener;
        this.center();
        this.setModal(modal);
        ui.addWindow((Window)this);
    }

    public final boolean isConfirmed() {
        return this.isConfirmed != null && this.isConfirmed != false;
    }

    public final boolean isCanceled() {
        return this.isConfirmed == null;
    }

    public final Listener getListener() {
        return this.confirmListener;
    }

    protected final void setNotOkButton(Button notOkButton) {
        this.notOkBtn = notOkButton;
    }

    public final Button getNotOkButton() {
        return this.notOkBtn;
    }

    protected final void setOkButton(Button okButton) {
        this.okBtn = okButton;
    }

    public final Button getOkButton() {
        return this.okBtn;
    }

    protected final void setCancelButton(Button cancelButton) {
        this.cancelBtn = cancelButton;
    }

    public final Button getCancelButton() {
        return this.cancelBtn;
    }

    protected final void setMessageLabel(Label message) {
        this.messageLabel = message;
    }

    public final void setMessage(String message) {
        this.originalMessageText = message;
        this.messageLabel.setValue(ContentMode.TEXT_WITH_NEWLINES == this.msgContentMode ? this.formatDialogMessage(message) : message);
    }

    public final String getMessage() {
        return this.originalMessageText;
    }

    public final ContentMode getContentMode() {
        return this.msgContentMode;
    }

    public final void setContentMode(ContentMode contentMode) {
        this.msgContentMode = contentMode;
        com.vaadin.shared.ui.ContentMode labelContentMode = com.vaadin.shared.ui.ContentMode.TEXT;
        switch (contentMode) {
            case TEXT_WITH_NEWLINES: 
            case TEXT: {
                labelContentMode = com.vaadin.shared.ui.ContentMode.TEXT;
                break;
            }
            case PREFORMATTED: {
                labelContentMode = com.vaadin.shared.ui.ContentMode.PREFORMATTED;
                break;
            }
            case HTML: {
                labelContentMode = com.vaadin.shared.ui.ContentMode.HTML;
            }
        }
        this.messageLabel.setContentMode(labelContentMode);
        this.messageLabel.setValue(contentMode == ContentMode.TEXT_WITH_NEWLINES ? this.formatDialogMessage(this.originalMessageText) : this.originalMessageText);
    }

    protected final String formatDialogMessage(String text) {
        return JsonPaintTarget.escapeXML((String)text).replaceAll("\n", "<br />");
    }

    protected final void setConfirmed(boolean confirmed) {
        this.isConfirmed = confirmed;
    }

    public static interface Listener
    extends Serializable {
        public void onClose(ConfirmDialog var1);
    }

    public static enum ContentMode {
        TEXT_WITH_NEWLINES,
        TEXT,
        PREFORMATTED,
        HTML;

    }

    public static interface Factory
    extends Serializable {
        public ConfirmDialog create(String var1, String var2, String var3, String var4, String var5);
    }
}

