/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.filters.impl.holtwinters;

import java.util.Arrays;
import java.util.stream.DoubleStream;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersOnlineAlgorithm;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersOnlineComponents;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersPointForecasterParams;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersTrainingMethod;
import org.springframework.util.Assert;

public class HoltWintersSimpleTrainingModel {
    private int n = 0;
    private final double[] firstCycle;
    private final double[] secondCycle;

    public HoltWintersSimpleTrainingModel(HoltWintersPointForecasterParams params) {
        this.firstCycle = new double[params.getFrequency()];
        this.secondCycle = new double[params.getFrequency()];
    }

    public void observeAndTrain(double y, HoltWintersPointForecasterParams params, HoltWintersOnlineComponents components) {
        this.checkNulls(params, components);
        this.checkTrainingMethod(params);
        this.checkStillInInitialTraining(params);
        int frequency = params.getFrequency();
        if (this.isBetween(this.n, 0, frequency - 1)) {
            this.firstCycle[this.n] = y;
        } else {
            this.secondCycle[this.n - frequency] = y;
        }
        if (this.n == params.calculateInitTrainingPeriod() - 1) {
            this.setLevel(components);
            this.setSeasonals(y, params, components);
            this.setBase(params, components);
            this.updateComponentsAndForecast(params, components);
        }
        ++this.n;
    }

    public boolean isTrainingComplete(HoltWintersPointForecasterParams params) {
        return this.n >= params.calculateInitTrainingPeriod();
    }

    private void updateComponentsAndForecast(HoltWintersPointForecasterParams params, HoltWintersOnlineComponents components) {
        HoltWintersOnlineAlgorithm algorithm = new HoltWintersOnlineAlgorithm();
        DoubleStream.concat(Arrays.stream(this.firstCycle), Arrays.stream(this.secondCycle)).forEach(y -> algorithm.observeValueAndUpdateForecast(y, params, components));
    }

    private void setLevel(HoltWintersOnlineComponents components) {
        components.setLevel(this.mean(this.firstCycle));
    }

    private void setBase(HoltWintersPointForecasterParams params, HoltWintersOnlineComponents components) {
        double base = (this.mean(this.secondCycle) - components.getLevel()) / (double)params.getFrequency();
        components.setBase(base);
    }

    private void setSeasonals(double y, HoltWintersPointForecasterParams params, HoltWintersOnlineComponents components) {
        for (int i = 0; i < params.getFrequency(); ++i) {
            double s = params.isMultiplicative() ? this.firstCycle[i] / components.getLevel() : this.firstCycle[i] - components.getLevel();
            components.setSeasonal(i, s, y);
        }
    }

    private void checkNulls(HoltWintersPointForecasterParams params, HoltWintersOnlineComponents components) {
        Assert.notNull((Object)params, (String)"params can't be null");
        Assert.notNull((Object)components, (String)"components can't be null");
    }

    private void checkTrainingMethod(HoltWintersPointForecasterParams params) {
        Assert.isTrue((boolean)HoltWintersTrainingMethod.SIMPLE.equals((Object)params.getInitTrainingMethod()), (String)String.format("Expected training method to be %s but was %s", new Object[]{HoltWintersTrainingMethod.SIMPLE, params.getInitTrainingMethod()}));
    }

    private void checkStillInInitialTraining(HoltWintersPointForecasterParams params) {
        Assert.isTrue((!this.isTrainingComplete(params) ? 1 : 0) != 0, (String)String.format("Training invoked %d times which is greater than the training window of frequency * 2 (%d * 2 = %d) observations.", this.n + 1, params.getFrequency(), params.calculateInitTrainingPeriod()));
    }

    private boolean isBetween(int x, int lower, int upper) {
        return lower <= x && x <= upper;
    }

    private double mean(double[] values) {
        return Arrays.stream(values).average().getAsDouble();
    }
}

