/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.graph;

import java.util.List;
import java.util.NoSuchElementException;
import org.opennms.integration.api.v1.annotations.Model;
import org.opennms.integration.api.v1.graph.GraphInfo;

@Model
public interface GraphContainerInfo {
    public String getContainerId();

    public String getLabel();

    public String getDescription();

    public List<GraphInfo> getGraphInfos();

    default public GraphInfo getGraphInfo(String namespace) {
        GraphInfo graphInfo = this.getGraphInfos().stream().filter(gi -> gi.getNamespace().equals(namespace)).findAny().orElseThrow(() -> new NoSuchElementException("No GraphInfo with namespace '" + namespace + "' found"));
        return graphInfo;
    }

    default public GraphInfo getDefaultGraphInfo() {
        return this.getGraphInfos().get(0);
    }
}

