/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.systemreport.formatters;

import java.util.Map;
import org.opennms.systemreport.SystemReportFormatter;
import org.opennms.systemreport.SystemReportPlugin;
import org.opennms.systemreport.event.CsvUtils;
import org.opennms.systemreport.formatters.AbstractSystemReportFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class CsvSystemReportFormatter
extends AbstractSystemReportFormatter
implements SystemReportFormatter {
    private static final Logger LOG = LoggerFactory.getLogger(CsvSystemReportFormatter.class);

    @Override
    public String getName() {
        return "csv";
    }

    @Override
    public String getDescription() {
        return "Simple human-readable indented csv";
    }

    @Override
    public String getContentType() {
        return "text/csv";
    }

    @Override
    public String getExtension() {
        return "csv";
    }

    @Override
    public boolean canStdout() {
        return true;
    }

    @Override
    public void write(SystemReportPlugin plugin) {
        if (plugin.getFullOutputOnly()) {
            return;
        }
        LOG.debug("write({})", (Object)plugin.getName());
        try {
            Map<String, Resource> pluginData = plugin.getEntries();
            Resource csvHeaders = pluginData.get("csvHeaders");
            Resource csvData = pluginData.get("csvData");
            CsvUtils.writeDataToStream(csvHeaders, csvData, this.getOutputStream(), Boolean.TRUE);
        }
        catch (Throwable e) {
            LOG.error("Error writing plugin data.", e);
        }
    }
}

