/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.collectors.resource.immutables;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opennms.integration.api.v1.collectors.CollectionSet;
import org.opennms.integration.api.v1.collectors.resource.CollectionSetResource;
import org.opennms.integration.api.v1.collectors.resource.immutables.ImmutableCollectionSetResource;
import org.opennms.integration.api.v1.util.ImmutableCollections;
import org.opennms.integration.api.v1.util.MutableCollections;

public final class ImmutableCollectionSet
implements CollectionSet {
    private final List<CollectionSetResource> collectionSetResources;
    private final long timestamp;
    private final CollectionSet.Status status;

    private ImmutableCollectionSet(Builder builder) {
        this.collectionSetResources = ImmutableCollections.with(ImmutableCollectionSet::mapToImmutable).newList(builder.collectionSetResources);
        this.timestamp = builder.timestamp;
        this.status = builder.status;
    }

    private static CollectionSetResource mapToImmutable(CollectionSetResource csr) {
        return ImmutableCollectionSetResource.typelessImmutableCopy(csr);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(CollectionSet collectionSet) {
        return new Builder(collectionSet);
    }

    public static CollectionSet immutableCopy(CollectionSet collectionSet) {
        if (collectionSet == null || collectionSet instanceof ImmutableCollectionSet) {
            return collectionSet;
        }
        return ImmutableCollectionSet.newBuilderFrom(collectionSet).build();
    }

    public List<CollectionSetResource> getCollectionSetResources() {
        return this.collectionSetResources;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public CollectionSet.Status getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableCollectionSet that = (ImmutableCollectionSet)o;
        return this.timestamp == that.timestamp && Objects.equals(this.collectionSetResources, that.collectionSetResources) && this.status == that.status;
    }

    public int hashCode() {
        return Objects.hash(this.collectionSetResources, this.timestamp, this.status);
    }

    public String toString() {
        return "ImmutableCollectionSet{collectionSetResources=" + this.collectionSetResources + ", timestamp=" + this.timestamp + ", status=" + this.status + "}";
    }

    public static final class Builder {
        private List<CollectionSetResource> collectionSetResources;
        private Long timestamp;
        private CollectionSet.Status status;

        private Builder() {
        }

        private Builder(CollectionSet collectionSet) {
            this.collectionSetResources = MutableCollections.copyListFromNullable(collectionSet.getCollectionSetResources());
            this.timestamp = collectionSet.getTimeStamp();
            this.status = collectionSet.getStatus();
        }

        public Builder setCollectionSetResources(List<CollectionSetResource> collectionSetResources) {
            this.collectionSetResources = collectionSetResources;
            return this;
        }

        public Builder addCollectionSetResource(CollectionSetResource collectionSetResource) {
            if (this.collectionSetResources == null) {
                this.collectionSetResources = new ArrayList<CollectionSetResource>();
            }
            this.collectionSetResources.add(collectionSetResource);
            return this;
        }

        public Builder setTimestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder setStatus(CollectionSet.Status status) {
            this.status = status;
            return this;
        }

        public CollectionSet build() {
            if (this.timestamp == null) {
                this.timestamp = System.currentTimeMillis();
            }
            if (this.status == null) {
                this.status = CollectionSet.Status.UNKNOWN;
            }
            return new ImmutableCollectionSet(this);
        }
    }
}

