/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.jcajce.provider.digest;

import java.security.MessageDigest;
import org.opennms.shaded.org.bouncycastle.crypto.Digest;
import org.opennms.shaded.org.bouncycastle.crypto.Xof;

public class BCMessageDigest
extends MessageDigest {
    protected Digest digest;
    protected int digestSize;

    protected BCMessageDigest(Digest digest) {
        super(digest.getAlgorithmName());
        this.digest = digest;
        this.digestSize = digest.getDigestSize();
    }

    protected BCMessageDigest(Xof xof, int n) {
        super(xof.getAlgorithmName());
        this.digest = xof;
        this.digestSize = n / 8;
    }

    public void engineReset() {
        this.digest.reset();
    }

    public void engineUpdate(byte by) {
        this.digest.update(by);
    }

    public void engineUpdate(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    public int engineGetDigestLength() {
        return this.digestSize;
    }

    public byte[] engineDigest() {
        byte[] byArray = new byte[this.digestSize];
        this.digest.doFinal(byArray, 0);
        return byArray;
    }
}

