/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.javamail;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.opennms.core.mate.api.EmptyScope;
import org.opennms.core.mate.api.EntityScopeProvider;
import org.opennms.core.mate.api.Interpolator;
import org.opennms.core.mate.api.Scope;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.FatalBeanException;

public abstract class JavaMailerConfig {
    private static final Logger LOG = LoggerFactory.getLogger(JavaMailerConfig.class);
    private static Scope secureCredentialsVaultScope;

    private static synchronized Scope getSecureCredentialsScope() {
        if (secureCredentialsVaultScope == null) {
            try {
                EntityScopeProvider entityScopeProvider = (EntityScopeProvider)BeanUtils.getBean((String)"daoContext", (String)"entityScopeProvider", EntityScopeProvider.class);
                if (entityScopeProvider != null) {
                    secureCredentialsVaultScope = entityScopeProvider.getScopeForScv();
                } else {
                    LOG.warn("JavaMailConfig: EntityScopeProvider is null, SecureCredentialsVault not available for metadata interpolation");
                }
            }
            catch (FatalBeanException e) {
                e.printStackTrace();
                LOG.warn("JavaMailConfig: Error retrieving EntityScopeProvider bean");
                secureCredentialsVaultScope = EmptyScope.EMPTY;
            }
        }
        return secureCredentialsVaultScope;
    }

    public static void setSecureCredentialsVaultScope(Scope secureCredentialsVaultScope) {
        JavaMailerConfig.secureCredentialsVaultScope = secureCredentialsVaultScope;
    }

    public static synchronized Properties getProperties(Scope scope) throws IOException {
        LOG.debug("JavaMailConfig: Loading javamail properties");
        Properties properties = new Properties();
        File configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.JAVA_MAIL_CONFIG_FILE_NAME);
        FileInputStream in = new FileInputStream(configFile);
        properties.load(in);
        ((InputStream)in).close();
        return JavaMailerConfig.interpolate(properties, scope);
    }

    public static synchronized Properties getProperties() throws IOException {
        return JavaMailerConfig.getProperties(JavaMailerConfig.getSecureCredentialsScope());
    }

    private static Properties interpolate(Properties properties, String key, Scope scope) {
        String value = properties.getProperty(key);
        if (value != null) {
            properties.put(key, Interpolator.interpolate((String)value, (Scope)scope).output);
        }
        return properties;
    }

    private static Properties interpolate(Properties properties, Scope scope) {
        if (scope == null) {
            LOG.warn("JavaMailConfig: Scope is null, cannot interpolate metadata of properties");
            return properties;
        }
        JavaMailerConfig.interpolate(properties, "org.opennms.core.utils.authenticateUser", scope);
        JavaMailerConfig.interpolate(properties, "org.opennms.core.utils.authenticatePassword", scope);
        return properties;
    }

    public static String interpolate(String string) {
        Scope scope = JavaMailerConfig.getSecureCredentialsScope();
        if (scope == null) {
            LOG.warn("JavaMailConfig: Scope is null, cannot interpolate metadata of string");
            return string;
        }
        return Interpolator.interpolate((String)string, (Scope)scope).output;
    }
}

