/*
 * Decompiled with CFR 0.152.
 */
package org.graylog2.syslog4j.server.impl.event;

import java.net.InetAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.graylog2.syslog4j.server.SyslogServerEventIF;
import org.graylog2.syslog4j.util.SyslogUtility;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class SyslogServerEvent
implements SyslogServerEventIF {
    private static final long serialVersionUID = 6136043067089899962L;
    public static final String DATE_FORMAT = "MMM dd HH:mm:ss yyyy";
    public static final String DATE_FORMAT_S = "MMM d HH:mm:ss yyyy";
    protected String charSet = "UTF-8";
    protected String rawString = null;
    protected byte[] rawBytes = null;
    protected int rawLength = -1;
    protected Date date = null;
    protected int level = -1;
    protected int facility = -1;
    protected String host = null;
    protected boolean isHostStrippedFromMessage = false;
    protected String message = null;
    protected InetAddress inetAddress = null;
    protected DateTimeZone sysLogServerTimeZone;

    protected SyslogServerEvent() {
    }

    public SyslogServerEvent(String message, InetAddress inetAddress) {
        this.initialize(message, inetAddress, null);
        this.parse();
    }

    public SyslogServerEvent(String message, InetAddress inetAddress, DateTimeZone sysLogServerTimeZone) {
        this.initialize(message, inetAddress, sysLogServerTimeZone);
        this.parse();
    }

    public SyslogServerEvent(byte[] message, int length, InetAddress inetAddress) {
        this.initialize(message, length, inetAddress, null);
        this.parse();
    }

    public SyslogServerEvent(byte[] message, int length, InetAddress inetAddress, DateTimeZone sysLogServerTimeZone) {
        this.initialize(message, length, inetAddress, sysLogServerTimeZone);
        this.parse();
    }

    protected void initialize(String message, InetAddress inetAddress, DateTimeZone sysLogServerTimeZone) {
        this.rawString = message;
        this.rawLength = message.length();
        this.inetAddress = inetAddress;
        this.message = message;
        this.sysLogServerTimeZone = sysLogServerTimeZone;
    }

    protected void initialize(byte[] message, int length, InetAddress inetAddress, DateTimeZone sysLogServerTimeZone) {
        this.rawBytes = message;
        this.rawLength = length;
        this.inetAddress = inetAddress;
        this.sysLogServerTimeZone = sysLogServerTimeZone;
    }

    protected void parseHost() {
        int i = this.message.indexOf(32);
        if (i > -1) {
            this.host = this.message.substring(0, i).trim();
        }
    }

    protected void parseDate() {
        int datelength = 16;
        String dateFormatS = DATE_FORMAT;
        boolean isDate8601 = false;
        if (this.message.length() > datelength) {
            if (this.message.charAt(5) == ' ') {
                datelength = 15;
                dateFormatS = DATE_FORMAT_S;
            }
            if (Character.isDigit(this.message.charAt(0))) {
                datelength = this.message.indexOf(32) + 1;
                isDate8601 = true;
            }
            String originalDate = this.message.substring(0, datelength - 1);
            try {
                this.date = !isDate8601 ? this.parseDateBasedOnFormat(originalDate, datelength, dateFormatS) : this.parse8601Date(originalDate).toDate();
                this.message = this.message.substring(datelength);
            }
            catch (ParseException pe) {
                this.date = new Date();
            }
        }
        this.parseHost();
    }

    private Date parseDateBasedOnFormat(String originalDate, int dateLength, String format) throws ParseException {
        String year = Integer.toString(Calendar.getInstance().get(1));
        String modifiedDate = originalDate + " " + year;
        SimpleDateFormat dateFormat = new SimpleDateFormat(format, Locale.ENGLISH);
        if (Objects.nonNull(this.sysLogServerTimeZone)) {
            dateFormat.setTimeZone(this.sysLogServerTimeZone.toTimeZone());
        }
        return dateFormat.parse(modifiedDate);
    }

    private DateTime parse8601Date(String date) {
        if (!this.hasTimeZone(date) && Objects.nonNull(this.sysLogServerTimeZone)) {
            return DateTime.parse((String)date, (DateTimeFormatter)ISODateTimeFormat.dateTimeParser().withZone(this.sysLogServerTimeZone));
        }
        return DateTime.parse((String)date);
    }

    protected boolean hasTimeZone(String date) {
        return date.substring(date.length() - 6).matches(".*[Z+-].*");
    }

    protected void parsePriority() {
        int i;
        if (this.message.charAt(0) == '<' && (i = this.message.indexOf(">")) <= 4 && i > -1) {
            String priorityStr = this.message.substring(1, i);
            int priority = 0;
            try {
                priority = Integer.parseInt(priorityStr);
                this.facility = priority >> 3;
                this.level = priority - (this.facility << 3);
                this.message = this.message.substring(i + 1);
                this.parseDate();
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.parseHost();
        }
    }

    protected void parse() {
        if (this.message == null) {
            this.message = SyslogUtility.newString(this, this.rawBytes, this.rawLength);
        }
        this.parsePriority();
    }

    @Override
    public int getFacility() {
        return this.facility;
    }

    @Override
    public void setFacility(int facility) {
        this.facility = facility;
    }

    @Override
    public byte[] getRaw() {
        if (this.rawString != null) {
            byte[] rawStringBytes = SyslogUtility.getBytes(this, this.rawString);
            return rawStringBytes;
        }
        if (this.rawBytes.length == this.rawLength) {
            return this.rawBytes;
        }
        byte[] newRawBytes = new byte[this.rawLength];
        System.arraycopy(this.rawBytes, 0, newRawBytes, 0, this.rawLength);
        return newRawBytes;
    }

    protected ZoneId getDefaultServerZoneId() {
        return Objects.isNull(this.sysLogServerTimeZone) ? ZoneOffset.UTC : this.sysLogServerTimeZone.toTimeZone().toZoneId();
    }

    public int getRawLength() {
        return this.rawLength;
    }

    @Override
    public Date getDate() {
        return this.date;
    }

    @Override
    public void setDate(Date date) {
        this.date = date;
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public boolean isHostStrippedFromMessage() {
        return this.isHostStrippedFromMessage;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getCharSet() {
        return this.charSet;
    }

    @Override
    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }
}

