/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.model;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.web.svclayer.model.AggregateStatus;
import org.opennms.web.svclayer.model.SimpleWebTable;

public class SurveillanceTable {
    String m_label = null;
    AggregateStatus[][] m_statusTable = null;
    Set<OnmsNode>[] m_rowNodes = null;
    Set<OnmsNode>[] m_columnNodes = null;
    String[] m_rowHeaders = null;
    String[] m_columnHeaders = null;
    private SimpleWebTable m_webTable;

    public SurveillanceTable() {
    }

    public SurveillanceTable(int rows, int columns) {
        this.m_statusTable = new AggregateStatus[rows][columns];
        this.m_rowNodes = new HashSet[rows];
        this.m_columnNodes = new HashSet[columns];
        this.m_rowHeaders = new String[rows];
        this.m_columnHeaders = new String[columns];
    }

    public void setWebTable(SimpleWebTable webTable) {
        this.m_webTable = webTable;
    }

    public SimpleWebTable getWebTable() {
        return this.m_webTable;
    }

    public void setStatus(int row, int col, AggregateStatus status) {
        this.m_statusTable[row][col] = status;
    }

    public AggregateStatus getStatus(int row, int col) {
        return this.m_statusTable[row][col];
    }

    public int getRowCount() {
        return this.m_rowHeaders.length;
    }

    public int getColumnCount() {
        return this.m_columnHeaders.length;
    }

    public AggregateStatus[] getStatusRow(int row) {
        return this.m_statusTable[row];
    }

    public List<List<AggregateStatus>> getOrderedRows() {
        LinkedList<List<AggregateStatus>> orderedRows = new LinkedList<List<AggregateStatus>>();
        for (AggregateStatus[] statusRow : this.m_statusTable) {
            orderedRows.add(this.getColumnOrderedRow(statusRow));
        }
        return orderedRows;
    }

    public Map<String, List<AggregateStatus>> getColumnOrderedRowsWithHeaders() {
        LinkedHashMap<String, List<AggregateStatus>> map = new LinkedHashMap<String, List<AggregateStatus>>();
        for (int i = 0; i < this.m_rowHeaders.length; ++i) {
            map.put(this.m_rowHeaders[i], this.getColumnOrderedRow(this.m_statusTable[i]));
        }
        return map;
    }

    public List<AggregateStatus> getColumnOrderedRow(AggregateStatus[] row) {
        LinkedList<AggregateStatus> orderedRow = new LinkedList<AggregateStatus>();
        for (AggregateStatus element : row) {
            orderedRow.add(element);
        }
        return orderedRow;
    }

    public List<AggregateStatus> getColumnOrderedRow(int row) {
        LinkedList<AggregateStatus> orderedRow = new LinkedList<AggregateStatus>();
        for (int i = 0; i < this.m_statusTable[row].length; ++i) {
            orderedRow.add(this.m_statusTable[row][i]);
        }
        return orderedRow;
    }

    public String getRowHeader(int row) {
        return this.m_rowHeaders[row];
    }

    public void setRowHeader(int row, String header) {
        this.m_rowHeaders[row] = header;
    }

    public String[] getRowHeaders() {
        return this.m_rowHeaders;
    }

    public List<String> getRowHeaderList() {
        return this.asLinkedList(this.m_rowHeaders);
    }

    public void setColumnHeader(int col, String header) {
        this.m_columnHeaders[col] = header;
    }

    public String[] getColumnHeaders() {
        return this.m_columnHeaders;
    }

    public List<String> getColumnHeaderList() {
        return this.asLinkedList(this.m_columnHeaders);
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setLabel(String label) {
        this.m_label = label;
    }

    public AggregateStatus[][] getStatusTable() {
        return this.m_statusTable;
    }

    private List<String> asLinkedList(String[] headers) {
        LinkedList<String> headerList = new LinkedList<String>();
        for (int i = 0; i < this.m_rowHeaders.length; ++i) {
            headerList.add(headers[i]);
        }
        return headerList;
    }

    public Set<OnmsNode>[] getRowNodes() {
        return this.m_rowNodes;
    }

    public void setRowNodes(Set<OnmsNode>[] rowNodes) {
        this.m_rowNodes = rowNodes;
    }

    public void setRowHeaders(String[] rowHeaders) {
        this.m_rowHeaders = rowHeaders;
    }

    public Set<OnmsNode>[] getColumnNodes() {
        return this.m_columnNodes;
    }

    public void setColumnNodes(Set<OnmsNode>[] columnNodes) {
        this.m_columnNodes = columnNodes;
    }

    public void setColumnHeaders(String[] columnHeaders) {
        this.m_columnHeaders = columnHeaders;
    }

    public void setStatusTable(AggregateStatus[][] statusTable) {
        this.m_statusTable = statusTable;
    }

    public Set<OnmsNode> getNodesForRow(int row) {
        return this.m_rowNodes[row];
    }

    public void setNodesForRow(int row, Collection<OnmsNode> nodes) {
        this.m_rowNodes[row] = new HashSet<OnmsNode>(nodes);
    }

    public Set<OnmsNode> getNodesForColumn(int col) {
        return this.m_columnNodes[col];
    }

    public void setNodesForColumn(int col, Collection<OnmsNode> columnNodes) {
        this.m_columnNodes[col] = new HashSet<OnmsNode>(columnNodes);
    }
}

