/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext2.cm.change.types;

import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import liquibase.ext2.cm.change.types.AbstractPropertyType;
import liquibase.parser.core.ParsedNode;
import org.opennms.features.config.dao.api.ConfigItem;

public class StringType
extends AbstractPropertyType {
    public StringType(List<ParsedNode> listOfAttributes) {
        super(listOfAttributes);
        this.configItem.setType(ConfigItem.Type.STRING);
        this.getAttributeValue("pattern").map(this::validateRegex).ifPresent(arg_0 -> ((ConfigItem)this.configItem).setPattern(arg_0));
        this.configItem.setDefaultValue(this.defaultValueOpt.orElse(null));
    }

    private String validateRegex(String regex) {
        try {
            Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid regex %s:  %s", regex, e.getMessage()));
        }
        return regex;
    }
}

